/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.framework.role.RoleTypeService;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class AwardUnitContactDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase
implements RoleTypeService {
    private AwardService awardService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        String awardIdStr = qualification.get("award");
        if (StringUtils.isNotBlank((CharSequence)awardIdStr) && awardIdStr.matches("\\d+")) {
            Long awardId = Long.valueOf(awardIdStr);
            Award award = this.getAwardService().getAward(awardId);
            return award.getAwardUnitContacts().stream().filter(awardUnitContact -> StringUtils.equals((CharSequence)awardUnitContact.getUnitAdministratorType().getDescription(), (CharSequence)roleName)).map(awardUnitContact -> RoleMembership.Builder.create(null, null, (String)awardUnitContact.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        return true;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }
}

