/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.lookup.AwardTransactionLookupService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardTransactionLookupServiceImpl
implements AwardTransactionLookupService {
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String INITIAL = "Initial";
    private BusinessObjectService businessObjectService;
    private static final Logger LOG = LogManager.getLogger(AwardTransactionLookupServiceImpl.class);

    @Override
    public Map<Integer, String> getApplicableTransactionIds(String awardNumber, Integer sequenceNumber) {
        if (this.isAuthorizedToAccess(awardNumber)) {
            if (StringUtils.isNotBlank((CharSequence)awardNumber) && awardNumber.contains(":")) {
                awardNumber = StringUtils.split((String)awardNumber, (String)":")[0];
            }
            ArrayList transactionIds = new ArrayList();
            Award award = this.getAwardVersion(awardNumber, sequenceNumber);
            transactionIds.addAll(award.getAwardAmountInfos().stream().filter(amountInfo -> amountInfo.getTransactionId() != null).map(AwardAmountInfo::getTransactionId).collect(Collectors.toList()));
            TreeMap<Integer, String> retval = new TreeMap<Integer, String>(Comparator.naturalOrder().reversed());
            transactionIds.stream().filter(id -> id != null).forEach(id -> retval.put(this.getAwardAmountInfoIndex(award, (Long)id), id.toString()));
            if (sequenceNumber == 1) {
                retval.put(0, INITIAL);
            }
            return retval;
        }
        return Collections.emptyMap();
    }

    protected int getAwardAmountInfoIndex(Award award, Long transactionId) {
        for (int i = 0; i < award.getAwardAmountInfos().size(); ++i) {
            if (!Objects.equals(award.getAwardAmountInfos().get(i).getTransactionId(), transactionId)) continue;
            return i;
        }
        return 0;
    }

    protected Award getAwardVersion(String awardNumber, int sequenceNumber) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(AWARD_NUMBER, awardNumber);
        values.put(SEQUENCE_NUMBER, sequenceNumber);
        List awards = this.businessObjectService.findMatching(Award.class, values);
        return (Award)awards.iterator().next();
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    private boolean isAuthorizedToAccess(String awardNumber) {
        boolean isAuthorized = true;
        if (awardNumber.contains(":")) {
            if (GlobalVariables.getUserSession() != null) {
                Map editModes;
                Object formObj;
                String[] invalues = StringUtils.split((String)awardNumber, (String)":");
                String docFormKey = invalues[1];
                isAuthorized = StringUtils.isBlank((CharSequence)docFormKey) ? false : ((formObj = GlobalVariables.getUserSession().retrieveObject(docFormKey)) == null || !(formObj instanceof AwardForm) ? false : BooleanUtils.toBoolean((String)((String)(editModes = ((AwardForm)formObj).getEditingMode()).get("fullEntry"))) || BooleanUtils.toBoolean((String)((String)editModes.get("viewOnly"))));
            } else {
                LOG.info("dwr/ajax does not have session ");
            }
        }
        return isAuthorized;
    }
}

