/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.rule;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.kra.award.home.ContactType;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.dao.DataIntegrityViolationException;

public class ContactTypeMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.canRecordBeDeleted(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.canRecordBeDeleted(document);
    }

    private boolean canRecordBeDeleted(MaintenanceDocument document) {
        boolean recordCanBeDeleted = true;
        ContactType contactType = (ContactType)document.getDocumentBusinessObject();
        if (StringUtils.isNotBlank((CharSequence)contactType.getContactTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("contactTypeCode", contactType.getContactTypeCode());
            try {
                this.boService.deleteMatching(ContactType.class, fieldValues);
            }
            catch (DataIntegrityViolationException dive) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.contactTypeCode", "error.contact.type.code.foreign.key.exists", new String[]{contactType.getContactTypeCode()});
                recordCanBeDeleted = false;
            }
        }
        return recordCanBeDeleted;
    }
}

