/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.timeandmoney;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistributionRule;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistributionRuleEvent;
import org.kuali.kra.timeandmoney.service.AwardFnaDistributionService;
import org.kuali.rice.kns.util.KNSGlobalVariables;

public class AwardDirectFandADistributionRuleImpl
extends KcTransactionalDocumentRuleBase
implements AwardDirectFandADistributionRule {
    private static final String NEW_AWARD_DIRECT_FNA_DISTRIBUTION = "newAwardDirectFandADistribution";
    private static final String START_DATE_REQUIRED = ".startDateRequired";
    private static final String END_DATE_REQUIRED = ".endDateRequired";
    private static final String DIRECT_COST_REQUIRED = ".directCostRequired";
    private static final String DIRECT_COST_POSITIVE = ".directCostPositive";
    private static final String INDIRECT_COST_REQUIRED = ".indirectCostRequired";
    private static final String INDIRECT_COST_POSITIVE = ".indirectCostPositive";
    private static final String INVALID_DATES = ".invalidDates";
    private static final String OVERLAPPING_DATE_RANGES = ".overlappingDateRanges";
    private static final String INVALID_TARGET_START_DATE = ".invalidStartDate";
    private static final String INVALID_TARGET_END_DATE = ".invalidEndDate";
    private static final String WARNING_AWARD_DIRECT_FNA_DISTRIBUTION_ANTICIPATED_MISMATCH = ".mismatchAnticipated";
    private static final String WARNING_BREAK_DATE_RANGE = ".breakDateRanges";
    AwardDirectFandADistribution awardDirectFandADistribution;
    List<AwardDirectFandADistribution> awardDirectFandADistributions;
    transient AwardAmountInfoService awardAmountInfoService;
    private transient AwardFnaDistributionService awardFnaDistributionService;

    @Override
    public boolean processAwardDirectFandADistributionBusinessRules(AwardDirectFandADistributionRuleEvent awardDirectFandADistributionRuleEvent) {
        this.awardDirectFandADistributions = awardDirectFandADistributionRuleEvent.getAwardDirectFandADistributionsForValidation();
        boolean validExistingDateRanges = this.existingDirectFandADistributionsDatesDontOverlap(this.awardDirectFandADistributions);
        boolean validStartDate = true;
        boolean validEndDate = true;
        boolean validAmounts = this.existingAmountsAreValid(this.awardDirectFandADistributions);
        boolean hasTimeAndMoneyBeenSaved = StringUtils.isNotBlank((CharSequence)awardDirectFandADistributionRuleEvent.getTimeAndMoneyDocument().getObjectId());
        boolean validTotalAnticipated = this.doTotalAnticipatedAmountValidOnExistingDistribution(this.awardDirectFandADistributions, hasTimeAndMoneyBeenSaved);
        boolean validConsecutiveDateRange = this.existingDirectFandADistributionsDatesNoBreak(this.awardDirectFandADistributions);
        if (this.awardDirectFandADistributions.size() > 0 && hasTimeAndMoneyBeenSaved) {
            this.awardDirectFandADistribution = this.awardDirectFandADistributions.get(0);
            validStartDate = this.isTargetStartAfterProjectStartDate(awardDirectFandADistributionRuleEvent);
            this.awardDirectFandADistribution = this.awardDirectFandADistributions.get(this.awardDirectFandADistributions.size() - 1);
            validEndDate = this.isTargetEndDatePriorToProjectEndDate(awardDirectFandADistributionRuleEvent);
        }
        return validExistingDateRanges && validStartDate && validEndDate;
    }

    @Override
    public boolean processAddAwardDirectFandADistributionBusinessRules(AwardDirectFandADistributionRuleEvent awardDirectFandADistributionRuleEvent) {
        this.awardDirectFandADistribution = awardDirectFandADistributionRuleEvent.getAwardDirectFandADistributionForValidation();
        List<AwardDirectFandADistribution> thisAwardDirectFandADistributions = awardDirectFandADistributionRuleEvent.getTimeAndMoneyDocument().getAward().getAwardDirectFandADistributions();
        boolean isValid = true;
        if (!this.isStartDateEntered()) {
            isValid = false;
        }
        if (!this.isEndDateEntered()) {
            isValid = false;
        }
        if (isValid && !this.isStartDatePriorToEndDate()) {
            isValid = false;
        }
        if (isValid) {
            boolean validDatePeriod;
            boolean bl = validDatePeriod = this.doTargetDatesFallWithinOpenPeriod(thisAwardDirectFandADistributions) && this.isTargetStartAfterProjectStartDate(awardDirectFandADistributionRuleEvent) && this.isTargetEndDatePriorToProjectEndDate(awardDirectFandADistributionRuleEvent);
            if (!validDatePeriod) {
                isValid = false;
            }
        }
        if (!this.isDirectCostValid()) {
            isValid = false;
        }
        if (!this.isIndirectCostValid()) {
            isValid = false;
        }
        return isValid;
    }

    boolean existingDirectFandADistributionsDatesDontOverlap(List<AwardDirectFandADistribution> thisAwardDirectFandADistributions) {
        boolean valid = true;
        int currentIndex = 0;
        for (AwardDirectFandADistribution thisAwardDirectFandADistribution : thisAwardDirectFandADistributions) {
            if (thisAwardDirectFandADistribution.getStartDate().after(thisAwardDirectFandADistribution.getEndDate())) {
                valid = false;
                this.reportError("newAwardDirectFandADistribution.invalidDates", "error.awardDirectFandADistribution.invalid.start.before.end.dates", new String[0]);
                break;
            }
            if (this.targetOverlapsWithExistingPeriods(thisAwardDirectFandADistribution, thisAwardDirectFandADistributions, currentIndex)) {
                valid = false;
                this.reportError("newAwardDirectFandADistribution.invalidDates", "error.awardDirectFandADistribution.overlapping.existing.dates", new String[0]);
                break;
            }
            ++currentIndex;
        }
        return valid;
    }

    boolean existingDirectFandADistributionsDatesNoBreak(List<AwardDirectFandADistribution> thisAwardDirectFandADistributions) {
        boolean valid = true;
        int currentIndex = 0;
        for (AwardDirectFandADistribution thisAwardDirectFandADistribution : thisAwardDirectFandADistributions) {
            if (currentIndex >= thisAwardDirectFandADistributions.size() - 1) continue;
            AwardDirectFandADistribution nextAwardDirectFandADistribution = thisAwardDirectFandADistributions.get(++currentIndex);
            if (!DateUtils.addDays((Date)thisAwardDirectFandADistribution.getEndDate(), (int)1).before(nextAwardDirectFandADistribution.getStartDate())) continue;
            this.reportWarning(WARNING_BREAK_DATE_RANGE, "warning.awardDirectFandADistribution.break.existing.dates", new String[0]);
            KNSGlobalVariables.getMessageList().add("warning.awardDirectFandADistribution.exists", new String[]{""});
            valid = false;
        }
        return valid;
    }

    boolean targetOverlapsWithExistingPeriods(AwardDirectFandADistribution thisAwardDirectFandADistribution, List<AwardDirectFandADistribution> thisAwardDirectFandADistributions, int currentIndex) {
        boolean invalid = false;
        java.sql.Date startDate = thisAwardDirectFandADistribution.getStartDate();
        java.sql.Date endDate = thisAwardDirectFandADistribution.getEndDate();
        int newCurrentIndex = 0;
        for (AwardDirectFandADistribution testAwardDirectFandADistribution : thisAwardDirectFandADistributions) {
            java.sql.Date testStartDate = testAwardDirectFandADistribution.getStartDate();
            java.sql.Date testEndDate = testAwardDirectFandADistribution.getEndDate();
            if (newCurrentIndex != currentIndex && (startDate.before(testEndDate) && startDate.after(testStartDate) || endDate.after(testStartDate) && endDate.before(testEndDate) || startDate.equals(testEndDate) || endDate.equals(testStartDate))) {
                invalid = true;
                break;
            }
            ++newCurrentIndex;
        }
        return invalid;
    }

    private boolean isStartDateEntered() {
        boolean valid = true;
        if (this.awardDirectFandADistribution.getStartDate() == null) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.startDateRequired", "error.awardDirectFandADistribution.start.date.required", new String[0]);
        }
        return valid;
    }

    private boolean isEndDateEntered() {
        boolean valid = true;
        if (this.awardDirectFandADistribution.getEndDate() == null) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.endDateRequired", "error.awardDirectFandADistribution.end.date.required", new String[0]);
        }
        return valid;
    }

    private boolean existingAmountsAreValid(List<AwardDirectFandADistribution> thisAwardDirectFandADistributions) {
        boolean valid = true;
        for (AwardDirectFandADistribution awardDirectFandADistribution : thisAwardDirectFandADistributions) {
            if (!this.isDirectCostValidOnExistingDistribution(awardDirectFandADistribution)) {
                valid = false;
            }
            if (this.isIndirectCostValidOnExistingDistribution(awardDirectFandADistribution)) continue;
            valid = false;
        }
        return valid;
    }

    private boolean isDirectCostValidOnExistingDistribution(AwardDirectFandADistribution thisAwardDirectFandADistribution) {
        boolean valid = true;
        ScaleTwoDecimal directCost = thisAwardDirectFandADistribution.getDirectCost();
        if (directCost == null) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.directCostRequired", "error.awardDirectFandADistribution.direct.cost.required", new String[0]);
        } else if (directCost.isNegative()) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.directCostPositive", "error.awardDirectFandADistribution.direct.cost.negative", new String[0]);
        }
        return valid;
    }

    private boolean doTotalAnticipatedAmountValidOnExistingDistribution(List<AwardDirectFandADistribution> thisAwardDirectFandADistributions, boolean hasTimeAndMoneyBeenSaved) {
        if (this.getAwardFnaDistributionService().disableFAndADistributionEqualityValidation()) {
            return true;
        }
        boolean valid = false;
        ScaleTwoDecimal awardAnticipatedTotal = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedFNAAmount = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedDirAmount = ScaleTwoDecimal.ZERO;
        if (this.awardDirectFandADistributions.size() > 0) {
            awardAnticipatedTotal = this.awardDirectFandADistributions.get(0).getAward().getAnticipatedTotal();
            for (AwardDirectFandADistribution awardDirectFandADistribution : thisAwardDirectFandADistributions) {
                calculatedFNAAmount = (ScaleTwoDecimal)calculatedFNAAmount.add((AbstractDecimal)awardDirectFandADistribution.getDirectCost());
                calculatedDirAmount = (ScaleTwoDecimal)calculatedDirAmount.add((AbstractDecimal)awardDirectFandADistribution.getIndirectCost());
            }
            if (awardAnticipatedTotal.equals((Object)calculatedFNAAmount.add((AbstractDecimal)calculatedDirAmount))) {
                valid = true;
            } else if (this.getAwardFnaDistributionService().displayAwardFAndADistributionEqualityValidationAsError()) {
                if (hasTimeAndMoneyBeenSaved) {
                    this.reportError(WARNING_AWARD_DIRECT_FNA_DISTRIBUTION_ANTICIPATED_MISMATCH, "warning.awardDirectFandADistribution.limitNotEqual.anticipated", this.awardDirectFandADistributions.get(0).getAward().getAwardNumber());
                    KNSGlobalVariables.getMessageList().add("warning.awardDirectFandADistribution.exists", new String[]{""});
                }
            } else if (this.getAwardFnaDistributionService().displayAwardFAndADistributionEqualityValidationAsWarning()) {
                this.reportWarning(WARNING_AWARD_DIRECT_FNA_DISTRIBUTION_ANTICIPATED_MISMATCH, "warning.awardDirectFandADistribution.limitNotEqual.anticipated", this.awardDirectFandADistributions.get(0).getAward().getAwardNumber());
                KNSGlobalVariables.getMessageList().add("warning.awardDirectFandADistribution.exists", new String[]{""});
            } else {
                valid = true;
            }
        }
        return valid;
    }

    protected AwardFnaDistributionService getAwardFnaDistributionService() {
        if (this.awardFnaDistributionService == null) {
            this.awardFnaDistributionService = KcServiceLocator.getService(AwardFnaDistributionService.class);
        }
        return this.awardFnaDistributionService;
    }

    private boolean isIndirectCostValidOnExistingDistribution(AwardDirectFandADistribution thisAwardDirectFandADistribution) {
        boolean valid = true;
        ScaleTwoDecimal indirectCost = thisAwardDirectFandADistribution.getIndirectCost();
        if (indirectCost == null) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.indirectCostRequired", "error.awardDirectFandADistribution.indirect.cost.required", new String[0]);
        } else if (indirectCost.isNegative()) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.indirectCostPositive", "error.awardDirectFandADistribution.indirect.cost.positive", new String[0]);
        }
        return valid;
    }

    private boolean isDirectCostValid() {
        boolean valid = true;
        ScaleTwoDecimal directCost = this.awardDirectFandADistribution.getDirectCost();
        if (directCost == null) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.directCostRequired", "error.awardDirectFandADistribution.direct.cost.required", new String[0]);
        } else if (!directCost.isPositive()) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.directCostPositive", "error.awardDirectFandADistribution.direct.cost.positive", new String[0]);
        }
        return valid;
    }

    private boolean isIndirectCostValid() {
        boolean valid = true;
        ScaleTwoDecimal indirectCost = this.awardDirectFandADistribution.getIndirectCost();
        if (indirectCost == null) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.indirectCostRequired", "error.awardDirectFandADistribution.indirect.cost.required", new String[0]);
        } else if (indirectCost.isNegative()) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.indirectCostPositive", "error.awardDirectFandADistribution.indirect.cost.positive", new String[0]);
        }
        return valid;
    }

    boolean isStartDatePriorToEndDate() {
        boolean valid = true;
        if (this.awardDirectFandADistribution.getStartDate().compareTo(this.awardDirectFandADistribution.getEndDate()) != -1) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.invalidDates", "error.awardDirectFandADistribution.invalid.start.end.dates", new String[0]);
        }
        return valid;
    }

    boolean doTargetDatesFallWithinOpenPeriod(List<AwardDirectFandADistribution> thisAwardDirectFandADistributions) {
        boolean valid = true;
        for (AwardDirectFandADistribution testAwardDirectFandADistribution : thisAwardDirectFandADistributions) {
            if (!this.doDateRangesOverlap(testAwardDirectFandADistribution, this.awardDirectFandADistribution)) continue;
            valid = false;
            this.reportError("newAwardDirectFandADistribution.overlappingDateRanges", "error.awardDirectFandADistribution.date.ranges.overlap", new String[0]);
        }
        return valid;
    }

    boolean doDateRangesOverlap(AwardDirectFandADistribution testAwardDirectFandADistribution, AwardDirectFandADistribution thisAwardDirectFandADistribution) {
        java.sql.Date testStartDate = testAwardDirectFandADistribution.getStartDate();
        java.sql.Date testEndDate = testAwardDirectFandADistribution.getEndDate();
        java.sql.Date startDate = thisAwardDirectFandADistribution.getStartDate();
        java.sql.Date endDate = thisAwardDirectFandADistribution.getEndDate();
        return startDate.before(testEndDate) && startDate.after(testStartDate) || endDate.after(testStartDate) && endDate.before(testEndDate);
    }

    boolean isTargetStartAfterProjectStartDate(AwardDirectFandADistributionRuleEvent awardDirectFandADistributionRuleEvent) {
        java.sql.Date targetStartDate = this.awardDirectFandADistribution.getStartDate();
        java.sql.Date projectStartDate = awardDirectFandADistributionRuleEvent.getTimeAndMoneyDocument().getAward().getAwardEffectiveDate();
        boolean valid = true;
        if (projectStartDate != null && projectStartDate.after(targetStartDate)) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.invalidStartDate", "error.awardDirectFandADistribution.invalid.start.date", new String[0]);
        }
        return valid;
    }

    boolean isTargetEndDatePriorToProjectEndDate(AwardDirectFandADistributionRuleEvent awardDirectFandADistributionRuleEvent) {
        java.sql.Date targetEndDate = this.awardDirectFandADistribution.getEndDate();
        java.sql.Date projectEndDate = this.getAwardAmountInfoService().fetchAwardAmountInfoWithHighestTransactionId(awardDirectFandADistributionRuleEvent.getTimeAndMoneyDocument().getAward().getAwardAmountInfos()).getFinalExpirationDate();
        boolean valid = true;
        if (projectEndDate.before(targetEndDate)) {
            valid = false;
            this.reportError("newAwardDirectFandADistribution.invalidEndDate", "error.awardDirectFandADistribution.invalid.end.date", new String[0]);
        }
        return valid;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        this.awardAmountInfoService = KcServiceLocator.getService(AwardAmountInfoService.class);
        return this.awardAmountInfoService;
    }

    public AwardDirectFandADistribution getAwardDirectFandADistribution() {
        return this.awardDirectFandADistribution;
    }

    public void setAwardDirectFandADistribution(AwardDirectFandADistribution awardDirectFandADistribution) {
        this.awardDirectFandADistribution = awardDirectFandADistribution;
    }

    public List<AwardDirectFandADistribution> getAwardDirectFandADistributions() {
        return this.awardDirectFandADistributions;
    }

    public void setAwardDirectFandADistributions(List<AwardDirectFandADistribution> awardDirectFandADistributions) {
        this.awardDirectFandADistributions = awardDirectFandADistributions;
    }
}

