/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.util.List;
import java.util.Map;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.CommentType;
import org.kuali.kra.bo.MutableComment;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class AbstractCommentFactory<T extends MutableComment> {
    protected abstract T newComment();

    public T createComment(String commentTypeCode, boolean checklistPrintFlag) {
        T comment = this.newComment();
        CommentType commentType = this.findCommentType(commentTypeCode);
        comment.setCommentType(commentType);
        comment.setCommentTypeCode(commentType.getCommentTypeCode());
        comment.setChecklistPrintFlag(checklistPrintFlag);
        comment.setComments("");
        return comment;
    }

    protected CommentType findCommentType(String commentTypeCode) {
        List commentTypes = this.getBusinessObjectService().findMatching(CommentType.class, Map.of("commentTypeCode", commentTypeCode));
        return commentTypes.stream().findFirst().orElse(null);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }
}

