/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.dao.ojb;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.dao.ExconProjectLookupDao;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.dao.impl.LookupDaoOjb;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.springmodules.orm.ojb.PersistenceBrokerTemplate;

public class ExconProjectLookupDaoOjb
extends LookupDaoOjb
implements ExconProjectLookupDao {
    @Override
    public List<ExconProject> getExconProjectSearchResults(Map<String, String> fieldValues) {
        boolean isLimited;
        if (StringUtils.equalsIgnoreCase((CharSequence)"BOTH", (CharSequence)fieldValues.get(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING))) {
            fieldValues.put(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING, "ACTIVE|PENDING");
        }
        Criteria criteria = this.getCollectionCriteriaFromMap((BusinessObject)new ExconProject(), fieldValues);
        criteria.addIn((Object)"projectId", this.getExconProjectIdsQuery(fieldValues));
        QueryByCriteria query = QueryFactory.newQuery(ExconProject.class, (Criteria)criteria, (boolean)false);
        query.addOrderByAscending("projectNumber");
        PersistenceBrokerTemplate persistenceBrokerTemplate = this.getPersistenceBrokerTemplate();
        Long totalNumResults = persistenceBrokerTemplate.getCount((Query)query);
        Integer limit = LookupUtils.getSearchResultsLimit(ExconProject.class);
        boolean bl = isLimited = limit != null && limit >= 0;
        if (isLimited) {
            query.setEndAtIndex(limit.intValue());
        }
        Collection searchResultsPage = persistenceBrokerTemplate.getCollectionByQuery((Query)query);
        return new CollectionIncomplete(searchResultsPage, totalNumResults);
    }

    private Query getExconProjectIdsQuery(Map<String, String> fieldValues) {
        Criteria criteria = new Criteria();
        String projectStatuses = fieldValues.get(ExconProject.EXCON_SEQUENCE_STATUS_PROPERTY_STRING);
        if (StringUtils.equals((CharSequence)projectStatuses, (CharSequence)"ACTIVE|PENDING")) {
            criteria.addIn("exconProjectSequenceStatus", List.of("ACTIVE", "PENDING"));
        } else if (projectStatuses != null) {
            criteria.addEqualTo("exconProjectSequenceStatus", (Object)projectStatuses);
        }
        ReportQueryByCriteria query = QueryFactory.newReportQuery(ExconProject.class, (Criteria)criteria);
        query.addGroupBy("projectNumber");
        query.setAttributes(new String[]{"max(projectId)"});
        return query;
    }
}

