/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.shipment;

import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.common.framework.unit.UnitService;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.excon.common.service.RPSRetrievalService;
import org.kuali.kra.excon.project.ExconProjectSanctionListFinder;
import org.kuali.kra.excon.shipment.document.ExconIntlShipmentDocument;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.location.api.country.CountryService;

public class ExconIntlShipment
extends KcPersistableBusinessObjectBase {
    private static final long serialVersionUID = 23441807371850L;
    private String documentNumber;
    private ExconIntlShipmentDocument exconIntlShipmentDocument;
    private Long shipmentId;
    private Boolean restrictedExport;
    private String shipmentDescription;
    private Boolean restrictedCountry;
    private String countryCode;
    private String sanctionListCode;
    private Boolean restrictedParty;
    private String receivingParty;
    private String rpsResultContent;
    private Boolean certificationInd;
    private String applicantId;
    private String applicantName;
    private String supervisorId;
    private String supervisorName;
    private String unitNumber;
    private String unitName;
    private String title;
    private transient RPSRetrievalService rpsRetrievalService;
    private transient CountryService countryService;
    private transient KcPersonService kcPersonService;
    private transient UnitService unitService;
    private transient PermissionService permissionService;

    public String getDocumentNumber() {
        if (this.documentNumber == null) {
            this.documentNumber = this.getExconIntlShipmentDocument().getDocumentNumber();
        }
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(Long shipmentId) {
        if (this.shipmentId == null && shipmentId != null) {
            this.setTitle();
        }
        this.shipmentId = shipmentId;
    }

    public String getTitle() {
        if (this.title == null && this.shipmentId != null) {
            this.setTitle();
        }
        return this.title;
    }

    public void setTitle() {
        this.title = "International Shipment Checklist #" + this.shipmentId.toString();
    }

    public Boolean getRestrictedExport() {
        return this.restrictedExport;
    }

    public void setRestrictedExport(Boolean restrictedExport) {
        this.restrictedExport = restrictedExport;
    }

    public String getShipmentDescription() {
        return this.shipmentDescription;
    }

    public void setShipmentDescription(String shipmentDescription) {
        this.shipmentDescription = shipmentDescription;
    }

    public Boolean getRestrictedCountry() {
        return this.restrictedCountry;
    }

    public void setRestrictedCountry(Boolean restrictedCountry) {
        this.restrictedCountry = restrictedCountry;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCountryName() {
        String countryName = "";
        if (!StringUtils.isEmpty((CharSequence)this.countryCode)) {
            countryName = this.getCountryService().getCountryByAlternateCode(this.countryCode).getName();
        }
        return countryName;
    }

    public String getSanctionListCode() {
        return this.sanctionListCode;
    }

    public void setSanctionListCode(String sanctionListCode) {
        this.sanctionListCode = sanctionListCode;
    }

    public String getSanctionListName() {
        if (this.sanctionListCode == null) {
            return null;
        }
        ExconProjectSanctionListFinder sanctionListFinder = new ExconProjectSanctionListFinder();
        return sanctionListFinder.getKeyLabel(this.sanctionListCode);
    }

    public Boolean getRestrictedParty() {
        return this.restrictedParty;
    }

    public void setRestrictedParty(Boolean restrictedParty) {
        this.restrictedParty = restrictedParty;
    }

    public String getReceivingParty() {
        return this.receivingParty;
    }

    public void setReceivingParty(String receivingParty) {
        this.receivingParty = receivingParty;
    }

    public String getRpsResultContent() {
        return this.rpsResultContent;
    }

    public void setRpsResultContent(String rpsResultContent) {
        this.rpsResultContent = rpsResultContent;
    }

    public int getNumMatches() {
        String rpsResultContent = this.getRpsResultContent();
        if (rpsResultContent != null) {
            return this.getRPSRetrievalService().getNumMatches(rpsResultContent);
        }
        return -1;
    }

    public Boolean getCertificationInd() {
        return this.certificationInd;
    }

    public void setCertificationInd(Boolean certificationInd) {
        this.certificationInd = certificationInd;
    }

    public String getApplicantId() {
        if (this.applicantId == null) {
            this.setApplicantId(GlobalVariables.getUserSession().getPrincipalId());
        }
        return this.applicantId;
    }

    public void setApplicantId(String applicantId) {
        KcPerson applicantPerson;
        if (applicantId != null && !Objects.equals(this.applicantId, applicantId) && (applicantPerson = this.getKcPersonService().getKcPersonByPersonId(applicantId)) != null) {
            this.setApplicantName(applicantPerson.getFullName());
        }
        this.applicantId = applicantId;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getSupervisorId() {
        return this.supervisorId;
    }

    public void setSupervisorId(String supervisorId) {
        KcPerson supervisorPerson;
        if (supervisorId != null && !Objects.equals(this.supervisorId, supervisorId) && (supervisorPerson = this.getKcPersonService().getKcPersonByPersonId(supervisorId)) != null) {
            this.setSupervisorName(supervisorPerson.getFullName());
        }
        this.supervisorId = supervisorId;
    }

    public String getSupervisorName() {
        return this.supervisorName;
    }

    public void setSupervisorName(String supervisorName) {
        this.supervisorName = supervisorName;
    }

    public String getUnitNumber() {
        if (this.unitNumber == null) {
            this.setUnitNumber(this.getKcPersonService().getKcPersonByPersonId(this.getApplicantId()).getUnit().getUnitNumber());
        }
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        if (unitNumber != null && !Objects.equals(unitNumber, this.unitNumber)) {
            this.setUnitName(this.getUnitService().getUnitName(unitNumber));
        }
        this.unitNumber = unitNumber;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Unit getUnit() {
        if (this.unitNumber != null) {
            return this.getUnitService().getUnit(this.unitNumber);
        }
        return null;
    }

    public void resetPersistenceState() {
        this.shipmentId = null;
    }

    public void setExconIntlShipmentDocument(ExconIntlShipmentDocument exconIntlShipmentDocument) {
        this.exconIntlShipmentDocument = exconIntlShipmentDocument;
    }

    public ExconIntlShipmentDocument getExconIntlShipmentDocument() {
        if (this.exconIntlShipmentDocument == null) {
            this.refreshReferenceObject("exconIntlShipmentDocument");
        }
        return this.exconIntlShipmentDocument;
    }

    public boolean getIsAdmin() {
        return this.getPermissionService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), "KC-EXCON", "Create Project Document", new HashMap());
    }

    public String getDocumentKey() {
        return "ExconIntlShipmentDocument";
    }

    protected RPSRetrievalService getRPSRetrievalService() {
        if (this.rpsRetrievalService == null) {
            this.rpsRetrievalService = KcServiceLocator.getServicesOfType(RPSRetrievalService.class).get(0);
        }
        return this.rpsRetrievalService;
    }

    public void setRpsRetrievalService(RPSRetrievalService rpsRetrievalService) {
        this.rpsRetrievalService = rpsRetrievalService;
    }

    protected CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = KcServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected UnitService getUnitService() {
        if (this.unitService == null) {
            this.unitService = KcServiceLocator.getService(UnitService.class);
        }
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KcServiceLocator.getService(PermissionService.class);
        }
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

