/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.customercreation;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.kfs.module.external.kc.dto.CustomerCreationStatusDto;
import org.kuali.kfs.module.external.kc.dto.CustomerTypeDto;
import org.kuali.kfs.module.external.kc.dto.RolodexDTO;
import org.kuali.kfs.module.external.kc.service.CustomerCreationService;
import org.kuali.kra.external.customercreation.CustomerCreationClient;
import org.kuali.kra.external.service.KcDtoService;
import org.kuali.kra.external.sponsor.SponsorDTO;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public abstract class CustomerCreationClientBase
implements CustomerCreationClient {
    protected static final String SOAP_SERVICE_NAME = "customerCreationServiceSOAP";
    protected static final QName SERVICE_NAME = new QName("http://kfs.kuali.org/kc-kfs/v2_0", "customerCreationServiceSOAP");
    private static final String ERROR_MESSAGE = "Cannot connect to the service. The service may be down, please try again later.";
    private static final Logger LOG = LogManager.getLogger(CustomerCreationClientBase.class);
    private KcDtoService<SponsorDTO, Sponsor> sponsorDtoService;
    private ParameterService parameterService;

    protected abstract CustomerCreationService getServiceHandle();

    @Override
    public List<String> createCustomer(Sponsor sponsor, String initiatedByPrincipalName) {
        try {
            CustomerCreationService port = this.getServiceHandle();
            LOG.info("Connecting to financial system...");
            CustomerCreationStatusDto status = port.createCustomer(this.createSponsorDto(sponsor), initiatedByPrincipalName);
            if (status.getErrors().isEmpty()) {
                sponsor.setCustomerNumber(status.getCustomerNumber());
                return null;
            }
            return status.getErrors();
        }
        catch (Exception e) {
            LOG.error(ERROR_MESSAGE + e.getMessage(), (Throwable)e);
            ArrayList<String> result = new ArrayList<String>();
            result.add(ERROR_MESSAGE + e.getMessage());
            return result;
        }
    }

    @Override
    public List<KeyValue> getCustomerTypes() {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        LOG.info("Connecting to financial system...");
        List<CustomerTypeDto> types = this.getServiceHandle().getCustomerTypes();
        for (CustomerTypeDto dto : types) {
            result.add((KeyValue)new ConcreteKeyValue(dto.getCustomerTypeCode(), dto.getCustomerTypeDescription()));
        }
        return result;
    }

    @Override
    public boolean isValidCustomer(String customerNumber) {
        LOG.info("Connecting to financial system...");
        return this.getServiceHandle().isValidCustomer(customerNumber);
    }

    public org.kuali.kfs.module.external.kc.dto.SponsorDTO createSponsorDto(Sponsor sponsor) {
        org.kuali.kfs.module.external.kc.dto.SponsorDTO dto = new org.kuali.kfs.module.external.kc.dto.SponsorDTO();
        try {
            SponsorDTO kcDto = this.getSponsorDtoService().buildDto(sponsor);
            org.kuali.kra.external.sponsor.RolodexDTO rolodex = kcDto.getContactInformation();
            kcDto.setContactInformation(null);
            BeanUtils.copyProperties((Object)dto, (Object)kcDto);
            dto.setContactInformation(new RolodexDTO());
            BeanUtils.copyProperties((Object)dto.getContactInformation(), (Object)rolodex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return dto;
    }

    public KcDtoService<SponsorDTO, Sponsor> getSponsorDtoService() {
        return this.sponsorDtoService;
    }

    @Override
    public void setSponsorDtoService(KcDtoService<SponsorDTO, Sponsor> sponsorDtoService) {
        this.sponsorDtoService = sponsorDtoService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

