/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministratorType;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalUnitContact;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class InstitutionalProposalUnitContactAddRuleImpl {
    public static final String INSTITUTIONAL_PROPOSAL_UNIT_CONTACT_LIST_ERROR_KEY = "unitContactsBean.unitContact.unitAdministratorTypeCode";
    public static final String ERROR_INSTITUTIONAL_PROPOSAL_UNIT_CONTACT_EXISTS = "error.institutionalProposalUnitContact.person.exists";
    public static final String ERROR_INSTITUTIONAL_PROPOSAL_CONTACT_ROLE_REQUIRED = "error.institutionalProposal.contact.person.role.required";
    private static final String PERSON_ERROR_KEY = "unitContactsBean.newInstitutionalProposalContact.fullName";

    public boolean processAddInstitutionalProposalUnitContactBusinessRules(InstitutionalProposal institutionalProposal, InstitutionalProposalUnitContact newUnitContact) {
        boolean valid = this.checkForSelectedContactAdministratorTypeCode(newUnitContact);
        valid &= this.checkForDuplicatePerson(institutionalProposal, newUnitContact);
        return valid &= this.checkForSelectedPerson(newUnitContact);
    }

    public boolean checkForSelectedContactAdministratorTypeCode(InstitutionalProposalUnitContact newContact) {
        boolean valid;
        InstitutionalProposalUnitContact institutionalProposalUnitContact = newContact;
        boolean bl = valid = institutionalProposalUnitContact.getUnitAdministratorTypeCode() != null;
        if (!valid) {
            GlobalVariables.getMessageMap().putError(INSTITUTIONAL_PROPOSAL_UNIT_CONTACT_LIST_ERROR_KEY, ERROR_INSTITUTIONAL_PROPOSAL_CONTACT_ROLE_REQUIRED, new String[0]);
        }
        return valid;
    }

    private boolean checkForSelectedPerson(InstitutionalProposalUnitContact newContact) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)newContact.getPersonId())) {
            if (StringUtils.isBlank((CharSequence)newContact.getFullName())) {
                GlobalVariables.getMessageMap().putError(PERSON_ERROR_KEY, "error.unitContact.missing.person", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError(PERSON_ERROR_KEY, "error.unitContact.invalid.person", new String[0]);
            }
            valid = false;
        }
        return valid;
    }

    boolean checkForDuplicatePerson(InstitutionalProposal institutionalProposal, InstitutionalProposalUnitContact newUnitContact) {
        boolean valid = true;
        for (InstitutionalProposalUnitContact unitContact : institutionalProposal.getInstitutionalProposalUnitContacts()) {
            valid = !StringUtils.equals((CharSequence)unitContact.getPersonId(), (CharSequence)newUnitContact.getPersonId()) || !StringUtils.equals((CharSequence)unitContact.getUnitAdministratorTypeCode(), (CharSequence)newUnitContact.getUnitAdministratorTypeCode());
            if (valid) continue;
            this.registerError(newUnitContact);
            break;
        }
        return valid;
    }

    private void registerError(InstitutionalProposalUnitContact newUnitContact) {
        String roleDescription = this.getRoleDescription(newUnitContact);
        GlobalVariables.getMessageMap().putError(PERSON_ERROR_KEY, ERROR_INSTITUTIONAL_PROPOSAL_UNIT_CONTACT_EXISTS, new String[]{newUnitContact.getContact().getFullName(), roleDescription});
    }

    private String getRoleDescription(InstitutionalProposalUnitContact newUnitContact) {
        String roleDescription = "";
        BusinessObjectService boService = KcServiceLocator.getService(BusinessObjectService.class);
        UnitAdministratorType aType = (UnitAdministratorType)boService.findBySinglePrimaryKey(UnitAdministratorType.class, (Object)newUnitContact.getUnitAdministratorTypeCode());
        if (aType != null) {
            roleDescription = aType.getDescription();
        }
        return roleDescription;
    }
}

