/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.rules;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.CostShareType;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddCostShareRule;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalAddCostShareRuleEvent;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class InstitutionalProposalAddCostShareRuleImpl
extends CostShareRuleResearchDocumentBase
implements InstitutionalProposalAddCostShareRule {
    private static final Logger LOG = LogManager.getLogger(InstitutionalProposalAddCostShareRuleImpl.class);
    private String fieldStarter = "";
    private boolean displayNullFieldErrors = true;
    private ParameterService parameterService;
    private ProposalBudgetService proposalBudgetService;
    private GlobalVariableService globalVariableService;

    @Override
    public boolean processAddInstitutionalProposalCostShareBusinessRules(InstitutionalProposalAddCostShareRuleEvent institutionalProposalAddCostShareRuleEvent) {
        this.fieldStarter = "institutionalProposalCostShareBean.newInstitutionalProposalCostShare";
        this.displayNullFieldErrors = true;
        return this.proccessRules(institutionalProposalAddCostShareRuleEvent);
    }

    @Override
    public boolean processInstitutionalProposalCostShareBusinessRules(InstitutionalProposalAddCostShareRuleEvent institutionalProposalAddCostShareRuleEvent, int i) {
        this.fieldStarter = "document.institutionalProposalList[0].institutionalProposalCostShares[" + i + "]";
        this.displayNullFieldErrors = false;
        return this.proccessRules(institutionalProposalAddCostShareRuleEvent);
    }

    private boolean proccessRules(InstitutionalProposalAddCostShareRuleEvent institutionalProposalAddCostShareRuleEvent) {
        InstitutionalProposalCostShare institutionalProposalCostShare = institutionalProposalAddCostShareRuleEvent.getCostShareForValidation();
        boolean isValid = true;
        if (this.isCostSharingApplicable().booleanValue() && this.isCostSharingEnforced().booleanValue()) {
            isValid = this.processCommonValidations(institutionalProposalCostShare);
            isValid &= this.validatePercentage(institutionalProposalCostShare.getCostSharePercentage());
            isValid &= this.validateCostShareType(institutionalProposalCostShare.getCostShareTypeCode());
            isValid &= this.validateAmount(institutionalProposalCostShare.getAmount());
            isValid &= this.validateSourceAccount(institutionalProposalCostShare.getSourceAccount());
            isValid &= this.validateUnit(institutionalProposalCostShare.getUnitNumber(), this.fieldStarter + ".unitNumber");
            isValid &= this.getProposalBudgetService().isValidSourceAccountCostShareType("E", institutionalProposalCostShare, institutionalProposalAddCostShareRuleEvent.getFieldName());
        }
        return isValid;
    }

    public Boolean isCostSharingEnforced() {
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "Document", "budgetCostSharingEnforcementFlag");
    }

    public Boolean isCostSharingApplicable() {
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "Document", "budgetCostSharingApplicabilityFlag");
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected ProposalBudgetService getProposalBudgetService() {
        if (this.proposalBudgetService == null) {
            this.proposalBudgetService = KcServiceLocator.getService(ProposalBudgetService.class);
        }
        return this.proposalBudgetService;
    }

    protected GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    public boolean processCommonValidations(InstitutionalProposalCostShare institutionalProposalCostShare) {
        return this.validateCostShareFiscalYearRange(institutionalProposalCostShare);
    }

    public boolean validateCostShareFiscalYearRange(InstitutionalProposalCostShare institutionalProposalCostShare) {
        String projectPeriodField = this.fieldStarter + ".projectPeriod";
        return this.validateProjectPeriod(institutionalProposalCostShare.getProjectPeriod(), projectPeriodField);
    }

    private boolean validatePercentage(ScaleTwoDecimal percentage) {
        boolean isValid = true;
        String costSharePercentageField = this.fieldStarter + ".costSharePercentage";
        if (percentage != null && percentage.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            isValid = false;
            this.reportError(costSharePercentageField, "error.awardCostShare.percentage.range", new String[0]);
        }
        return isValid;
    }

    public boolean addValidationMessage(String validationMessageType, String field, String errorMessageKey, String ... errorParameters) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"E", (CharSequence)validationMessageType)) {
            this.getGlobalVariableService().getMessageMap().putError(field, errorMessageKey, errorParameters);
            return Boolean.FALSE;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"W", (CharSequence)validationMessageType)) {
            this.getGlobalVariableService().getMessageMap().putWarning(field, errorMessageKey, errorParameters);
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public String getValidationMessageType() {
        return this.getParameterService().getParameterValueAsString("KC-GEN", "All", "Cost_Share_Account_Validation_Message");
    }

    public boolean isCostShareTypeEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "ENABLE_COST_SHARE_ACCOUNT_VALIDATION");
    }

    private boolean validateCostShareType(Integer costShareTypeCode) {
        boolean isValid = true;
        String costShareTypeCodeField = this.fieldStarter + ".costShareTypeCode";
        if (costShareTypeCode == null) {
            if (this.isCostShareTypeEnabled()) {
                this.addValidationMessage(this.getValidationMessageType(), costShareTypeCodeField, "error.budget.distribution.costShareTypeMissing", new String[0]);
            } else {
                isValid = false;
                if (this.displayNullFieldErrors) {
                    this.reportError(costShareTypeCodeField, "error.institutionalProposalCostShare.costShareTypeCode.required", new String[0]);
                } else {
                    LOG.warn(String.format("Unreported validation error %s for field %s", "error.institutionalProposalCostShare.costShareTypeCode.required", costShareTypeCodeField));
                }
            }
        } else {
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put("costShareTypeCode", costShareTypeCode);
            if (this.getBusinessObjectService().countMatching(CostShareType.class, fieldValues) != 1) {
                isValid = false;
                this.reportError(costShareTypeCodeField, "error.institutionalProposalCostShare.costShareTypeCode.invalid", costShareTypeCode.toString());
            }
        }
        return isValid;
    }

    private boolean validateAmount(ScaleTwoDecimal commitmentAmount) {
        boolean isValid = true;
        String commitmentAmountField = this.fieldStarter + ".amount";
        if (commitmentAmount == null) {
            isValid = false;
            if (this.displayNullFieldErrors) {
                this.reportError(commitmentAmountField, "error.institutionalProposalCostShare.amount.required", new String[0]);
            } else {
                LOG.warn(String.format("Unreported validation error %s for field %s", "error.institutionalProposalCostShare.amount.required", commitmentAmountField));
            }
        } else if (commitmentAmount.isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            isValid = false;
            this.reportError(commitmentAmountField, "error.institutionalProposalCostShare.amount.invalid", commitmentAmount.toString());
        }
        return isValid;
    }

    private boolean validateSourceAccount(String sourceAccount) {
        boolean isValid = true;
        String sourceAccountField = this.fieldStarter + ".sourceAccount";
        if (StringUtils.isEmpty((CharSequence)sourceAccount)) {
            if (this.isCostShareTypeEnabled()) {
                this.addValidationMessage(this.getValidationMessageType(), sourceAccountField, "error.budget.distribution.sourceMissing", "Cost Sharing");
            } else {
                isValid = false;
                if (this.displayNullFieldErrors) {
                    this.reportError(sourceAccountField, "error.institutionalProposalCostShare.sourceAccount.required", new String[0]);
                } else {
                    LOG.warn(String.format("Unreported validation error %s for field %s", "error.institutionalProposalCostShare.sourceAccount.required", sourceAccountField));
                }
            }
        }
        return isValid;
    }
}

