/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.institutionalproposal.document.InstitutionalProposalDocument;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalNotepad;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalNoteAttachmentService;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;
import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.service.AttachmentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.NoteType;

public class InstitutionalProposalNoteAttachmentServiceImpl
implements InstitutionalProposalNoteAttachmentService {
    private AttachmentService attachmentService;
    private NoteService noteService;

    @Override
    public ActionForward addNote(ActionMapping mapping, InstitutionalProposalForm institutionalProposalForm) throws Exception {
        InstitutionalProposalNotepad notepad = institutionalProposalForm.getInstitutionalProposalNotepadBean().getNewInstitutionalProposalNotepad();
        BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(InstitutionalProposalNotepad.class.getName());
        if (institutionalProposalForm.getAttachmentFile() != null) {
            if (!businessObjectEntry.isBoNotesEnabled()) {
                throw new RuntimeException("to add attachments, the DD file for InstitutionalProposalNotepad must be configured for boNotesEnabled=true");
            }
            FormFile attachmentFile = institutionalProposalForm.getAttachmentFile();
            if (attachmentFile == null) {
                GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "attachmentFile"), "error.uploadFile.null", new String[0]);
            }
            Note newNote = new Note();
            newNote.setNoteText("Default text, will never be shown to user.");
            newNote.setNoteTypeCode(NoteType.BUSINESS_OBJECT.getCode());
            newNote.setNotePostedTimestampToCurrent();
            Attachment attachment = null;
            if (attachmentFile != null && !StringUtils.isBlank((CharSequence)attachmentFile.getFileName())) {
                if (attachmentFile.getFileSize() == 0) {
                    GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "attachmentFile"), "error.uploadFile.empty", new String[]{attachmentFile.getFileName()});
                } else {
                    String attachmentType = null;
                    attachment = this.getAttachmentService().createAttachment((GloballyUnique)notepad, attachmentFile.getFileName(), attachmentFile.getContentType(), attachmentFile.getFileSize(), attachmentFile.getInputStream(), attachmentType);
                }
                Note tmpNote = this.getNoteService().createNote(newNote, (GloballyUnique)notepad, GlobalVariables.getUserSession().getPrincipalId());
                tmpNote.addAttachment(attachment);
                notepad.getAttachments().add(tmpNote);
            }
        }
        institutionalProposalForm.getInstitutionalProposalNotepadBean().addNote(institutionalProposalForm.getInstitutionalProposalNotepadBean());
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward deleteNote(ActionMapping mapping, InstitutionalProposalForm institutionalProposalForm, int selection) throws Exception {
        InstitutionalProposalDocument document = institutionalProposalForm.getInstitutionalProposalDocument();
        InstitutionalProposalNotepad ipNotepad = document.getInstitutionalProposal().getInstitutionalProposalNotepads().get(selection);
        if (ipNotepad.getAttachments().size() > 0) {
            Note attachmentNote = ipNotepad.getAttachments().get(0);
            Attachment attachment = attachmentNote.getAttachment();
            if (attachment != null) {
                if (attachmentNote.getNoteIdentifier() != null) {
                    attachment.refreshNonUpdateableReferences();
                }
                this.getAttachmentService().deleteAttachmentContents(attachment);
            }
            if (!document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
                this.getNoteService().deleteNote(attachmentNote);
            }
        }
        document.getInstitutionalProposal().getInstitutionalProposalNotepads().remove(selection);
        return mapping.findForward("basic");
    }

    public AttachmentService getAttachmentService() {
        return this.attachmentService;
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
    }

    public NoteService getNoteService() {
        return this.noteService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }
}

