/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.bo;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.negotiations.bo.NegotiationsGroupingBase;
import org.kuali.rice.kns.service.KNSServiceLocator;

public class NegotiationsMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = -4054390064236611181L;

    @Override
    public void prepareForSave() {
        NegotiationsGroupingBase negotiationBase = (NegotiationsGroupingBase)this.businessObject;
        boolean isNew = negotiationBase.getId() == null;
        this.validateCode(negotiationBase, isNew);
        super.prepareForSave();
    }

    private void validateCode(NegotiationsGroupingBase negotiationBase, boolean isNew) {
        List dbCollection = KNSServiceLocator.getBusinessObjectService().findAll(negotiationBase.getClass());
        for (NegotiationsGroupingBase dbBase : dbCollection) {
            if (isNew) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)negotiationBase.getCode(), (CharSequence)dbBase.getCode())) continue;
                this.reportError(negotiationBase.getCode());
                continue;
            }
            if (negotiationBase.getId().equals(dbBase.getId()) || !StringUtils.equalsIgnoreCase((CharSequence)negotiationBase.getCode(), (CharSequence)dbBase.getCode())) continue;
            this.reportError(negotiationBase.getCode());
        }
    }

    private void reportError(String codeValue) {
        ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        errorReporter.reportError("document.newMaintainableObject.code", "error.negotiations.codeAlreadyUsed", codeValue);
    }
}

