/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.rules;

import java.sql.Date;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.AwardDateRulesHelper;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.rule.event.TimeAndMoneyAwardDateSaveEvent;
import org.kuali.kra.timeandmoney.rules.TimeAndMoneyAwardDateSaveRule;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class TimeAndMoneyAwardDateSaveRuleImpl
extends KcTransactionalDocumentRuleBase
implements TimeAndMoneyAwardDateSaveRule {
    private static final String AWARD_EFFECTIVE_DATE_PROPERTY = "document.awardList[0].awardEffectiveDate";
    private ParameterService parameterService;

    @Override
    public boolean processSaveAwardDatesBusinessRules(TimeAndMoneyAwardDateSaveEvent timeAndMoneyAwardDateSaveEvent) {
        TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyAwardDateSaveEvent.getDocument();
        this.clearFieldsFromUserSessionMap();
        return this.validateObligatedDates(timeAndMoneyDocument);
    }

    private boolean validateObligatedDates(TimeAndMoneyDocument document) {
        boolean valid = true;
        int i = 0;
        Optional<AwardHierarchyNode> rootAwardNode = document.getAwardHierarchyNodes().values().stream().min(Comparator.comparing(AwardHierarchyNode::getAwardNumber));
        Date rootObligatedEndDate = rootAwardNode.map(AwardHierarchyNode::getObligationExpirationDate).orElse(null);
        Date rootObligatedStartDate = rootAwardNode.map(AwardHierarchyNode::getCurrentFundEffectiveDate).orElse(null);
        Date rootProjectEndDate = rootAwardNode.map(AwardHierarchyNode::getFinalExpirationDate).orElse(null);
        boolean validateEndDateBehavior = this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "AwardHierarchy_EndDateValidated", Boolean.valueOf(true));
        for (Map.Entry<String, AwardHierarchyNode> awardHierarchyNode : document.getAwardHierarchyNodes().entrySet()) {
            Award award = this.getAwardVersionService().getWorkingAwardVersion(awardHierarchyNode.getValue().getAwardNumber());
            AwardAmountInfo aai = this.getAwardAmountInfoService().fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
            Date obligatedStartDate = awardHierarchyNode.getValue().getCurrentFundEffectiveDate();
            Date obligatedEndDate = awardHierarchyNode.getValue().getObligationExpirationDate();
            Date projectEndDate = awardHierarchyNode.getValue().getFinalExpirationDate();
            if (aai.getAward() == null) {
                aai.refreshReferenceObject("award");
            }
            Date projectStartDate = aai.getAward().getAwardEffectiveDate();
            ScaleTwoDecimal obligatedTotal = awardHierarchyNode.getValue().getAmountObligatedToDate();
            MessageMap errorMap = GlobalVariables.getMessageMap();
            String fieldStarter = "awardHierarchyNodeItems[" + (i + 1);
            String awardId = award.getAwardNumber();
            String finalExpirationField = fieldStarter + "].finalExpirationDate";
            String obligationExirationField = fieldStarter + "].obligationExpirationDate";
            String currentFundEffectiveField = fieldStarter + "].currentFundEffectiveDate";
            boolean validateProjectStartBeforeProjectEnd = AwardDateRulesHelper.validateProjectStartBeforeProjectEnd(errorMap, projectStartDate, projectEndDate, finalExpirationField, awardId);
            boolean validateObligationStartBeforeObligationEnd = AwardDateRulesHelper.validateObligationStartBeforeObligationEnd(errorMap, obligatedStartDate, obligatedEndDate, obligationExirationField, awardId);
            boolean validateProjectStartBeforeObligationStart = AwardDateRulesHelper.validateProjectStartBeforeObligationStart(errorMap, projectStartDate, obligatedStartDate, currentFundEffectiveField, awardId);
            boolean validateProjectStartBeforeObligationEnd = AwardDateRulesHelper.validateProjectStartBeforeObligationEnd(errorMap, projectStartDate, obligatedEndDate, obligationExirationField, awardId);
            boolean validateObligationStartBeforeProjectEnd = AwardDateRulesHelper.validateObligationStartBeforeProjectEnd(errorMap, obligatedStartDate, projectEndDate, currentFundEffectiveField, awardId);
            boolean validateObligationEndBeforeProjectEnd = AwardDateRulesHelper.validateObligationEndBeforeProjectEnd(errorMap, obligatedEndDate, projectEndDate, obligationExirationField, awardId);
            boolean validateObligationStartAfterParent = true;
            boolean validateObligationEndBeforeParent = true;
            boolean validateProjectEndBeforeParent = true;
            if (validateEndDateBehavior) {
                validateObligationStartAfterParent = AwardDateRulesHelper.validateParentObligationStartBeforeObligationStart(errorMap, obligatedStartDate, rootObligatedStartDate, currentFundEffectiveField, awardId);
                validateObligationEndBeforeParent = AwardDateRulesHelper.validateObligationEndBeforeParentObligationEnd(errorMap, obligatedEndDate, rootObligatedEndDate, obligationExirationField, awardId);
                validateProjectEndBeforeParent = AwardDateRulesHelper.validateProjectEndBeforeParentProjectEnd(errorMap, projectEndDate, rootProjectEndDate, finalExpirationField, awardId);
            }
            if (!validateProjectStartBeforeProjectEnd || !validateProjectEndBeforeParent) {
                this.addFieldToUserSessionMap(finalExpirationField);
            }
            if (!(validateProjectStartBeforeObligationStart && validateObligationStartBeforeProjectEnd && validateObligationStartAfterParent)) {
                this.addFieldToUserSessionMap(currentFundEffectiveField);
            }
            if (!(validateObligationStartBeforeObligationEnd && validateProjectStartBeforeObligationEnd && validateObligationEndBeforeProjectEnd && validateObligationEndBeforeParent)) {
                this.addFieldToUserSessionMap(obligationExirationField);
            }
            boolean bl = valid = valid && validateProjectStartBeforeProjectEnd && validateObligationStartBeforeObligationEnd && validateProjectStartBeforeObligationStart && validateProjectStartBeforeObligationEnd && validateObligationStartBeforeProjectEnd && validateObligationEndBeforeProjectEnd && validateObligationStartAfterParent && validateObligationEndBeforeParent && validateProjectEndBeforeParent;
            if (obligatedTotal != null && obligatedTotal.isGreaterThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
                if (obligatedStartDate == null) {
                    if ("1".equals(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"))) {
                        this.reportError(currentFundEffectiveField, "error.award.effective.date.total", new String[0]);
                    } else {
                        this.reportError(currentFundEffectiveField, "error.award.effective.date", new String[0]);
                    }
                    this.addFieldToUserSessionMap(currentFundEffectiveField);
                    valid = false;
                }
                if (obligatedEndDate == null) {
                    if ("1".equals(this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST"))) {
                        this.reportError(obligationExirationField, "error.obligation.expiration.date.total", new String[0]);
                    } else {
                        this.reportError(obligationExirationField, "error.obligation.expiration.date", new String[0]);
                    }
                    this.addFieldToUserSessionMap(obligationExirationField);
                    valid = false;
                }
            }
            ++i;
        }
        return valid;
    }

    protected void addFieldToUserSessionMap(String fieldName) {
        if (KNSGlobalVariables.getKualiForm() instanceof TimeAndMoneyForm) {
            TimeAndMoneyForm form = (TimeAndMoneyForm)KNSGlobalVariables.getKualiForm();
            form.getFieldsInError().add(fieldName);
        }
    }

    protected void clearFieldsFromUserSessionMap() {
        if (KNSGlobalVariables.getKualiForm() instanceof TimeAndMoneyForm) {
            TimeAndMoneyForm form = (TimeAndMoneyForm)KNSGlobalVariables.getKualiForm();
            form.getFieldsInError().clear();
        }
    }

    private AwardAmountInfoService getAwardAmountInfoService() {
        return KcServiceLocator.getService(AwardAmountInfoService.class);
    }

    public AwardVersionService getAwardVersionService() {
        return KcServiceLocator.getService(AwardVersionService.class);
    }

    public boolean enforceAwardStartDatePopulated(Award award) {
        boolean valid = true;
        if (award.getAwardEffectiveDate() == null) {
            this.reportError(AWARD_EFFECTIVE_DATE_PROPERTY, "error.award.effective.date.timeAndMoney", new String[0]);
            valid = false;
        }
        return valid;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

