/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.core;

import java.util.HashMap;
import org.kuali.coeus.common.budget.framework.core.Account;
import org.kuali.coeus.common.budget.framework.core.ValidSourceAccountsCostShareType;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.kra.bo.CostShareType;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class ValidSourceAccountsCostShareTypeMaintenanceRule
extends KcMaintenanceDocumentRuleBase {
    public static final String COST_SHARE_TYPE_CODE = "costShareTypeCode";
    public static final String SOURCE_ACCOUNT_CODE = "sourceAccountCode";
    public static final String FIELD_NAME = "Cost share type code and Source account code";
    public static final String SECTION_ID = "Edit Valid Source Accounts Cost Share Type";
    public static final String CODE = "code";
    public static final String SOURCE_ACCOUNT_CODE_FIELD = "Source Account Code";
    public static final String COST_SHARE_TYPE_CODE_FIELD = "Cost Share Type Code";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.doesEntryExist(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = Boolean.TRUE;
        ValidSourceAccountsCostShareType validSourceAccountsCostShareType = (ValidSourceAccountsCostShareType)document.getDocumentBusinessObject();
        HashMap<String, Number> pk = new HashMap<String, Number>();
        pk.put(CODE, validSourceAccountsCostShareType.getSourceAccountCode());
        valid &= this.checkExistenceFromTable(Account.class, pk, SOURCE_ACCOUNT_CODE, SOURCE_ACCOUNT_CODE_FIELD);
        pk = new HashMap();
        pk.put(COST_SHARE_TYPE_CODE, validSourceAccountsCostShareType.getCostShareTypeCode());
        return (valid &= this.checkExistenceFromTable(CostShareType.class, pk, COST_SHARE_TYPE_CODE, COST_SHARE_TYPE_CODE_FIELD)) && this.doesEntryExist(document) != false;
    }

    protected Boolean doesEntryExist(MaintenanceDocument document) {
        String maintenanceAction = document.getNewMaintainableObject().getMaintenanceAction();
        if (!maintenanceAction.equals("Delete") && !maintenanceAction.equals("Edit")) {
            ValidSourceAccountsCostShareType validSourceAccountsCostShareType = (ValidSourceAccountsCostShareType)document.getDocumentBusinessObject();
            return this.validate(validSourceAccountsCostShareType);
        }
        return Boolean.TRUE;
    }

    private boolean validate(ValidSourceAccountsCostShareType validSourceAccountsCostShareType) {
        boolean valid;
        HashMap<String, Number> pk = new HashMap<String, Number>();
        pk.put(COST_SHARE_TYPE_CODE, validSourceAccountsCostShareType.getCostShareTypeCode());
        pk.put(SOURCE_ACCOUNT_CODE, validSourceAccountsCostShareType.getSourceAccountCode());
        boolean bl = valid = this.getBoService().countMatching(ValidSourceAccountsCostShareType.class, pk) == 0;
        if (!valid) {
            this.getGlobalVariableService().getMessageMap().putErrorWithoutFullErrorPath(SECTION_ID, "error.duplicate.element", new String[]{FIELD_NAME, validSourceAccountsCostShareType.getCostShareTypeCode().toString() + " and " + validSourceAccountsCostShareType.getSourceAccountCode()});
        }
        return valid;
    }
}

