/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.period;

import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetNumberOfMonthsService;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModular;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="BUDGET_PERIODS")
public class BudgetPeriod
extends KcPersistableBusinessObjectBase
implements BudgetPeriodContract {
    private static final long serialVersionUID = -7318331486891820078L;
    @PortableSequenceGenerator(name="SEQ_BUDGET_PERIOD_NUMBER")
    @GeneratedValue(generator="SEQ_BUDGET_PERIOD_NUMBER")
    @Id
    @Column(name="BUDGET_PERIOD_NUMBER")
    private Long budgetPeriodId;
    @Column(name="BUDGET_PERIOD")
    private Integer budgetPeriod;
    @Column(name="COMMENTS")
    @Lob
    private String comments;
    @Column(name="COST_SHARING_AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal costSharingAmount;
    @Column(name="END_DATE")
    private Date endDate;
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="TOTAL_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalCost;
    @Column(name="TOTAL_COST_LIMIT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalCostLimit;
    @Column(name="TOTAL_DIRECT_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalDirectCost;
    @Column(name="TOTAL_DIRECT_LESS_SUBCON_FA")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalDirectCostLessSubcontractorFA;
    @Column(name="TOTAL_INDIRECT_COST")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal totalIndirectCost;
    @Column(name="UNDERRECOVERY_AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal underrecoveryAmount;
    @OneToMany(mappedBy="budgetPeriodBO", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetLineItem> budgetLineItems;
    @Column(name="NUM_PARTICIPANTS")
    private Integer numberOfParticipants;
    @Column(name="TOTAL_DIRECT_COST_LIMIT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal directCostLimit;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="budgetPeriodObj", orphanRemoval=true, cascade={CascadeType.ALL})
    private BudgetModular budgetModular;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    private Budget budget;
    @Transient
    private ScaleTwoDecimal expenseTotal;
    @Transient
    private Date oldEndDate;
    @Transient
    private Date oldStartDate;
    @Transient
    private String budgetParentId;
    @Transient
    private String institutionalProposalNumber;
    @Transient
    private Integer institutionalProposalVersion;
    @Transient
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");

    public BudgetPeriod() {
        this.budgetLineItems = new ArrayList<BudgetLineItem>();
    }

    public Long getBudgetId() {
        return this.getBudget().getBudgetId();
    }

    public static Comparator<BudgetPeriod> getBudgetPeriodDateComparator() {
        return new BudgetPeriodDateComparator();
    }

    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public String getLabel() {
        return this.budgetPeriod + ": " + this.getDateRangeLabel();
    }

    public String getDateRangeLabel() {
        return this.dateFormatter.format(this.startDate) + " - " + this.dateFormatter.format(this.endDate);
    }

    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public ScaleTwoDecimal getCostSharingAmount() {
        return this.costSharingAmount == null ? ScaleTwoDecimal.ZERO : this.costSharingAmount;
    }

    public void setCostSharingAmount(ScaleTwoDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public ScaleTwoDecimal getTotalCost() {
        return this.totalCost == null ? ScaleTwoDecimal.ZERO : this.totalCost;
    }

    public void setTotalCost(ScaleTwoDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public ScaleTwoDecimal getTotalCostLimit() {
        return this.totalCostLimit == null ? ScaleTwoDecimal.ZERO : this.totalCostLimit;
    }

    public void setTotalCostLimit(ScaleTwoDecimal totalCostLimit) {
        this.totalCostLimit = totalCostLimit;
    }

    public ScaleTwoDecimal getTotalDirectCost() {
        return this.totalDirectCost == null ? ScaleTwoDecimal.ZERO : this.totalDirectCost;
    }

    public void setTotalDirectCost(ScaleTwoDecimal totalDirectCost) {
        this.totalDirectCost = totalDirectCost;
    }

    public ScaleTwoDecimal getTotalDirectCostForSync() {
        return this.budget.getExcludeSubconFAFromDirectCostSync() != false ? this.getTotalDirectCostLessSubcontractorFA() : this.getTotalDirectCost();
    }

    public ScaleTwoDecimal getTotalDirectCostLessSubcontractorFA() {
        return this.totalDirectCostLessSubcontractorFA == null ? ScaleTwoDecimal.ZERO : this.totalDirectCostLessSubcontractorFA;
    }

    public void setTotalDirectCostLessSubcontractorFA(ScaleTwoDecimal totalDirectCostLessSubcontractorFA) {
        this.totalDirectCostLessSubcontractorFA = totalDirectCostLessSubcontractorFA;
    }

    public ScaleTwoDecimal getTotalIndirectCost() {
        return this.totalIndirectCost == null ? ScaleTwoDecimal.ZERO : this.totalIndirectCost;
    }

    public void setTotalIndirectCost(ScaleTwoDecimal totalIndirectCost) {
        this.totalIndirectCost = totalIndirectCost;
    }

    public ScaleTwoDecimal getUnderrecoveryAmount() {
        return this.underrecoveryAmount == null ? ScaleTwoDecimal.ZERO : this.underrecoveryAmount;
    }

    public void setUnderrecoveryAmount(ScaleTwoDecimal underrecoveryAmount) {
        this.underrecoveryAmount = underrecoveryAmount;
    }

    public BudgetLineItem getBudgetLineItem(int index) {
        List<BudgetLineItem> items = this.getBudgetLineItems();
        while (items.size() <= index) {
            items.add(this.getNewBudgetLineItem());
        }
        return items.get(index);
    }

    public BudgetLineItem getNewBudgetLineItem() {
        return new BudgetLineItem();
    }

    public BudgetModular getBudgetModular() {
        return this.budgetModular;
    }

    public void setBudgetModular(BudgetModular budgetModular) {
        this.budgetModular = budgetModular;
    }

    public List<BudgetLineItem> getBudgetLineItems() {
        Collections.sort(this.budgetLineItems);
        return this.budgetLineItems;
    }

    public void setBudgetLineItems(List<BudgetLineItem> budgetLineItems) {
        this.budgetLineItems = budgetLineItems;
    }

    public boolean isReadOnly() {
        return this.budgetLineItems != null && this.budgetLineItems.size() > 0;
    }

    public ScaleTwoDecimal getExpenseTotal() {
        return this.expenseTotal;
    }

    public void setExpenseTotal(ScaleTwoDecimal expenseTotal) {
        this.expenseTotal = expenseTotal;
    }

    public int calculateFiscalYear(Date fiscalYearStartDateTime) {
        if (this.startDate == null || fiscalYearStartDateTime == null) {
            return 0;
        }
        Date fiscalYearStartDate = DateUtils.clearTimeFields(fiscalYearStartDateTime);
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(this.startDate);
        int startDateYear = calendar.get(1);
        calendar.setTime(fiscalYearStartDate);
        calendar.set(1, startDateYear);
        Date startDateYearFiscalYearBeginning = new Date(calendar.getTimeInMillis());
        return this.startDate.compareTo(startDateYearFiscalYearBeginning) < 0 ? startDateYear : ++startDateYear;
    }

    public int getPeriodFiscalYear() {
        return this.calculateFiscalYear(this.budget.loadFiscalYearStart());
    }

    public String getDateRange() {
        StringBuffer dateRange = new StringBuffer();
        if (this.getStartDate() != null && this.getEndDate() != null) {
            dateRange.append(this.getDateRangeLabel());
        }
        return dateRange.toString();
    }

    public Date getOldEndDate() {
        return this.oldEndDate;
    }

    public void setOldEndDate(Date oldEndDate) {
        this.oldEndDate = oldEndDate;
    }

    public Date getOldStartDate() {
        return this.oldStartDate;
    }

    public void setOldStartDate(Date oldStartDate) {
        this.oldStartDate = oldStartDate;
    }

    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    public final ScaleTwoDecimal getSumUnderreoveryAmountFromLineItems() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)lineItem.getUnderrecoveryAmount());
        }
        return amount;
    }

    public final ScaleTwoDecimal getSumCostSharingAmountFromLineItems() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)lineItem.getCostSharingAmount());
        }
        return amount;
    }

    public final ScaleTwoDecimal getSumTotalCostSharingAmountFromLineItems() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)lineItem.getTotalCostSharingAmount());
        }
        return amount;
    }

    public final ScaleTwoDecimal getSumDirectCostAmountFromLineItems() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)lineItem.getDirectCost());
        }
        return amount;
    }

    public final ScaleTwoDecimal getSumIndirectCostAmountFromLineItems() {
        ScaleTwoDecimal amount = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem lineItem : this.getBudgetLineItems()) {
            amount = (ScaleTwoDecimal)amount.add((AbstractDecimal)lineItem.getIndirectCost());
        }
        return amount;
    }

    public final ScaleTwoDecimal getSumTotalCostAmountFromLineItems() {
        return (ScaleTwoDecimal)this.getSumDirectCostAmountFromLineItems().add((AbstractDecimal)this.getSumIndirectCostAmountFromLineItems());
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public void setBudgetParentId(String budgetParentId) {
        this.budgetParentId = budgetParentId;
    }

    public String getBudgetParentId() {
        return this.budgetParentId;
    }

    public String getInstitutionalProposalNumber() {
        return this.institutionalProposalNumber;
    }

    public void setInstitutionalProposalNumber(String institutionalProposalNumber) {
        this.institutionalProposalNumber = institutionalProposalNumber;
    }

    public Integer getInstitutionalProposalVersion() {
        return this.institutionalProposalVersion;
    }

    public void setInstitutionalProposalVersion(Integer institutionalProposalVersion) {
        this.institutionalProposalVersion = institutionalProposalVersion;
    }

    public ScaleTwoDecimal getDirectCostLimit() {
        return this.directCostLimit == null ? ScaleTwoDecimal.ZERO : this.directCostLimit;
    }

    public void setDirectCostLimit(ScaleTwoDecimal directCostLimit) {
        this.directCostLimit = directCostLimit;
    }

    public String getNumberOfMonths() {
        return String.valueOf(this.getProposalBudgetNumberOfMonthsService().getNumberOfMonth(this.getStartDate(), this.getEndDate()));
    }

    protected ProposalBudgetNumberOfMonthsService getProposalBudgetNumberOfMonthsService() {
        return KcServiceLocator.getService(ProposalBudgetNumberOfMonthsService.class);
    }

    public Integer getNumberOfParticipants() {
        return this.numberOfParticipants;
    }

    public void setNumberOfParticipants(Integer numberOfParticipants) {
        this.numberOfParticipants = numberOfParticipants;
    }

    public final boolean hasParticipantSupportItems() {
        return this.getBudgetLineItems().stream().anyMatch(budgetLineItem -> budgetLineItem.getBudgetCategory().getBudgetCategoryType().isCategoryParticipantSupport());
    }

    private static class BudgetPeriodDateComparator
    implements Comparator<BudgetPeriod>,
    Serializable {
        private static final long serialVersionUID = 201595688750841114L;
        private static final int FIRST_EQUALS_SECOND = 0;
        private static final int FIRST_LESS_THAN_SECOND = -1;

        private BudgetPeriodDateComparator() {
        }

        @Override
        public int compare(BudgetPeriod bp1, BudgetPeriod bp2) {
            int result = this.compareDates(bp1.getStartDate(), bp2.getStartDate());
            if (result == 0) {
                result = this.compareDates(bp1.getEndDate(), bp2.getEndDate());
            }
            return result;
        }

        private int compareDates(Date d1, Date d2) {
            if (d1 != null) {
                return d1.compareTo(d2);
            }
            return d2 != null ? -1 : 0;
        }
    }
}

