/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategory;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.common.budget.impl.print.BudgetBaseStream;
import org.kuali.coeus.common.budget.impl.print.BudgetDataPeriodVO;
import org.kuali.coeus.common.budget.impl.print.SalaryTypeVO;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.printing.schema.BudgetPeriodData;
import org.kuali.kra.printing.schema.BudgetSalaryDocument;
import org.kuali.kra.printing.schema.SalaryType;

public abstract class BudgetBaseSalaryStream
extends BudgetBaseStream<BudgetSalaryDocument> {
    protected static final String SEPARATER_STRING = " - ";
    protected static final String OVERHEAD_RATE_PREFIX = "OH - ";
    protected static final String PERIOD_COST_TOTAL = "Total";
    protected static final String CALCULATED_AMOUNT_COST_ELEMENT_DESC = "Calculated Amount";

    @Override
    public Class<BudgetSalaryDocument> type() {
        return BudgetSalaryDocument.class;
    }

    protected BudgetSalaryDocument.BudgetSalary getBudgetSalaryTypeXmlObject() {
        BudgetSalaryDocument.BudgetSalary budgetSalary = (BudgetSalaryDocument.BudgetSalary)BudgetSalaryDocument.BudgetSalary.Factory.newInstance();
        BudgetParent bdP = this.budget.getBudgetParent();
        String parentNumber = bdP.getParentNumber();
        if (parentNumber != null) {
            budgetSalary.setProposalNumber(parentNumber);
            budgetSalary.setParentTypeName(bdP.getParentTypeName());
        }
        this.setBudgetSalaryTypeBasicInformation(budgetSalary);
        String principleInvestigatorName = bdP.getParentPIName();
        if (principleInvestigatorName != null) {
            budgetSalary.setPIName(principleInvestigatorName);
        }
        if (bdP.getParentTitle() != null) {
            budgetSalary.setTitle(bdP.getParentTitle());
        }
        return budgetSalary;
    }

    private void setBudgetSalaryTypeBasicInformation(BudgetSalaryDocument.BudgetSalary budgetSalary) {
        if (this.budget.getBudgetVersionNumber() != null) {
            budgetSalary.setBudgetVersion(this.budget.getBudgetVersionNumber());
        }
        budgetSalary.setCurrentDate(this.dateTimeService.getCurrentCalendar());
        if (this.budget.getStartDate() != null) {
            budgetSalary.setStartDate(this.dateTimeService.getCalendar(this.budget.getStartDate()));
        }
        if (this.budget.getEndDate() != null) {
            budgetSalary.setEndDate(this.dateTimeService.getCalendar(this.budget.getEndDate()));
        }
        if (this.budget.getBudgetPeriods() != null) {
            budgetSalary.setTotalPeriod(this.budget.getBudgetPeriods().size());
        }
        if (this.budget.getComments() != null && this.budget.getPrintBudgetCommentFlag() != null && this.budget.getPrintBudgetCommentFlag().equals("true")) {
            budgetSalary.setComments(this.budget.getComments());
        }
        this.budget.setPrintBudgetCommentFlag(null);
    }

    protected SalaryType getSalaryTypeXmlObject(String costElementDesc, String costElementCode, String name, BudgetPeriodData[] budgetPeriodArray, ScaleTwoDecimal total) {
        SalaryType salaryType = (SalaryType)SalaryType.Factory.newInstance();
        if (costElementDesc != null) {
            salaryType.setCostElementDesc(costElementDesc);
        }
        if (costElementCode != null) {
            salaryType.setCostElementCode(costElementCode);
        }
        if (name != null) {
            salaryType.setName(name);
        }
        if (budgetPeriodArray != null) {
            salaryType.setPeriodArray(budgetPeriodArray);
        }
        if (total != null) {
            salaryType.setTotal(total.bigDecimalValue());
        }
        return salaryType;
    }

    protected SalaryType[] getBudgetTotalAndSummarySalaryTypes(boolean includeNonPersonnel) {
        ArrayList<SalaryTypeVO> salaryTypeVoList = new ArrayList<SalaryTypeVO>();
        ArrayList<List<BudgetLineItemCalculatedAmount>> budgetLineItemCalcAmountsList = new ArrayList<List<BudgetLineItemCalculatedAmount>>();
        Map<String, String> lineItems = this.getListOfCostElementDescription(budgetLineItemCalcAmountsList);
        for (String costElemetDesc : lineItems.keySet()) {
            salaryTypeVoList.add(this.getSalaryTypeVOForCostElement(costElemetDesc, lineItems.get(costElemetDesc)));
        }
        this.setSalaryTypesForLineItemCalcuAmount(salaryTypeVoList, includeNonPersonnel);
        List<SalaryType> salaryTypeList = this.getListOfSalaryTypeXmlObjects(salaryTypeVoList);
        return salaryTypeList.toArray(new SalaryType[0]);
    }

    private Map<String, String> getListOfCostElementDescription(List<List<BudgetLineItemCalculatedAmount>> budgetLineItemCalcAmountsList) {
        HashMap<String, String> lineItems = new HashMap<String, String>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String costElementDesc;
                List<BudgetLineItemCalculatedAmount> budgetLineItemCalcAmounts = budgetLineItem.getBudgetLineItemCalculatedAmounts();
                budgetLineItemCalcAmountsList.add(budgetLineItemCalcAmounts);
                if (budgetLineItem.getCostElementBO() == null || (costElementDesc = budgetLineItem.getCostElementBO().getDescription()) == null || lineItems.containsKey(costElementDesc) || budgetLineItem.getCostElementBO().getCostElement() == null) continue;
                lineItems.put(costElementDesc, budgetLineItem.getCostElementBO().getCostElement());
            }
        }
        return lineItems;
    }

    protected SalaryTypeVO getSalaryTypeVOForCostElement(String costElemetDesc, String costElementCode) {
        SalaryTypeVO salaryTypeVO = new SalaryTypeVO();
        salaryTypeVO.setCostElement(costElemetDesc);
        salaryTypeVO.setCostElementCode(costElementCode);
        salaryTypeVO.setName(costElemetDesc);
        salaryTypeVO.setBudgetPeriodVOs(this.getBudgetDataPeriodVOsForCostElement(costElemetDesc));
        return salaryTypeVO;
    }

    private List<BudgetDataPeriodVO> getBudgetDataPeriodVOsForCostElement(String costElementDesc) {
        ArrayList<BudgetDataPeriodVO> budgetPeriodDataList = new ArrayList<BudgetDataPeriodVO>();
        int budgetPeriodDataId = 0;
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            BudgetDataPeriodVO budgetDataPeriodVO = new BudgetDataPeriodVO();
            budgetDataPeriodVO.setBudgetPeriodId(++budgetPeriodDataId);
            ScaleTwoDecimal periodCost = ScaleTwoDecimal.ZERO;
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                if (lineItem.getCostElementBO() == null || lineItem.getCostElementBO().getDescription() == null || !lineItem.getCostElementBO().getDescription().equals(costElementDesc)) continue;
                periodCost = (ScaleTwoDecimal)periodCost.add((AbstractDecimal)lineItem.getLineItemCost());
            }
            budgetDataPeriodVO.setPeriodCost(periodCost);
            budgetPeriodDataList.add(budgetDataPeriodVO);
        }
        return budgetPeriodDataList;
    }

    protected void setSalaryTypesForLineItemCalcuAmount(List<SalaryTypeVO> salaryTypeVoList, boolean includeNonPersonnel) {
        ArrayList<String> calculatedAmountDescList = new ArrayList<String>();
        SalaryTypeVO salaryTypeVO = new SalaryTypeVO();
        salaryTypeVO.setCostElement(CALCULATED_AMOUNT_COST_ELEMENT_DESC);
        salaryTypeVoList.add(salaryTypeVO);
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : new ArrayList<BudgetLineItem>(budgetPeriod.getBudgetLineItems())) {
                List<BudgetLineItemCalculatedAmount> budgetLineItemCalculatedAmounts = budgetLineItem.getBudgetLineItemCalculatedAmounts();
                for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItemCalculatedAmounts) {
                    String rateClassCode = budgetLineItemCalcAmount.getRateClassCode();
                    String rateTypeCode = budgetLineItemCalcAmount.getRateTypeCode();
                    RateClass rateClass = this.getRateClassBo(rateClassCode);
                    String costElementDesc = this.getCostElementDescriptionForLineItem(budgetLineItemCalcAmount, rateClass);
                    if (costElementDesc == null || calculatedAmountDescList.contains(costElementDesc)) continue;
                    calculatedAmountDescList.add(costElementDesc);
                    SalaryTypeVO salaryTypeVOForCalculatedAmount = new SalaryTypeVO();
                    salaryTypeVOForCalculatedAmount.setName(costElementDesc);
                    List<BudgetDataPeriodVO> budgetPeriodDataList = this.getBudgetDataPeriodsForCalculatedAmounts(rateClassCode, rateTypeCode, includeNonPersonnel);
                    salaryTypeVOForCalculatedAmount.setBudgetPeriodVOs(budgetPeriodDataList);
                    salaryTypeVoList.add(salaryTypeVOForCalculatedAmount);
                }
            }
        }
    }

    private String getBudgetCategoryTypeCode(BudgetLineItem budgetLineItem) {
        String budgetCategoryType = null;
        BudgetCategory budgetCategory = budgetLineItem.getBudgetCategory();
        if (budgetCategory != null) {
            budgetCategoryType = budgetCategory.getBudgetCategoryTypeCode();
        }
        return budgetCategoryType;
    }

    protected boolean isPersonnel(String budgetCategoryType) {
        boolean personnelFound = false;
        if (budgetCategoryType.equalsIgnoreCase("P")) {
            personnelFound = true;
        }
        return personnelFound;
    }

    protected List<BudgetDataPeriodVO> getBudgetDataPeriodsForCalculatedAmounts(String rateClassCode, String rateTypeCode, boolean includeNonPersonnel) {
        ArrayList<BudgetDataPeriodVO> budgetPeriodDataList = new ArrayList<BudgetDataPeriodVO>();
        int budgetPeriodDataId = 0;
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            BudgetDataPeriodVO budgetPeriodVO = new BudgetDataPeriodVO();
            budgetPeriodVO.setBudgetPeriodId(++budgetPeriodDataId);
            ScaleTwoDecimal periodCost = ScaleTwoDecimal.ZERO;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String budgetCategoryType = this.getBudgetCategoryTypeCode(budgetLineItem);
                if (!includeNonPersonnel && !this.isPersonnel(budgetCategoryType)) continue;
                for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (budgetLineItemCalcAmount.getRateClassCode() == null || !budgetLineItemCalcAmount.getRateClassCode().equals(rateClassCode) || budgetLineItemCalcAmount.getRateTypeCode() == null || !budgetLineItemCalcAmount.getRateTypeCode().equals(rateTypeCode)) continue;
                    periodCost = (ScaleTwoDecimal)periodCost.add((AbstractDecimal)budgetLineItemCalcAmount.getCalculatedCost());
                }
            }
            budgetPeriodVO.setPeriodCost(periodCost);
            budgetPeriodDataList.add(budgetPeriodVO);
        }
        return budgetPeriodDataList;
    }

    private String getCostElementDescriptionForLineItem(BudgetLineItemCalculatedAmount budgetLineItemCalcAmount, RateClass rateClass) {
        String costElementDesc = null;
        if (budgetLineItemCalcAmount.getRateTypeDescription() != null) {
            if (rateClass != null && rateClass.getRateClassTypeCode() != null && rateClass.getRateClassTypeCode().equals(RateClassType.OVERHEAD.getRateClassType())) {
                costElementDesc = OVERHEAD_RATE_PREFIX + budgetLineItemCalcAmount.getRateTypeDescription();
            } else if (rateClass != null && rateClass.getDescription() != null) {
                costElementDesc = rateClass.getDescription() + SEPARATER_STRING + budgetLineItemCalcAmount.getRateTypeDescription();
            }
        }
        return costElementDesc;
    }

    private RateClass getRateClassBo(String rateClassCode) {
        return (RateClass)this.dataObjectService.find(RateClass.class, (Object)rateClassCode);
    }

    protected List<SalaryType> getListOfSalaryTypeXmlObjects(List<SalaryTypeVO> salaryTypeVoList) {
        ArrayList<SalaryType> salaryTypeList = new ArrayList<SalaryType>();
        HashMap<Integer, ScaleTwoDecimal> budgetPeriodWiseTotalMap = new HashMap<Integer, ScaleTwoDecimal>();
        if (!salaryTypeVoList.isEmpty()) {
            for (SalaryTypeVO salaryTypeVO : salaryTypeVoList) {
                BudgetPeriodData[] budgetPeriodArray = null;
                List<BudgetDataPeriodVO> budgetDataPeriodVOs = salaryTypeVO.getBudgetPeriodVOs();
                if (budgetDataPeriodVOs != null) {
                    budgetPeriodArray = this.getBudgetDataPeriodXmlObjects(budgetDataPeriodVOs, budgetPeriodWiseTotalMap);
                    ScaleTwoDecimal total = this.getTotalForCostElementOfAllPeriodsCost(budgetDataPeriodVOs);
                    salaryTypeVO.setTotal(total);
                }
                salaryTypeList.add(this.getSalaryTypeXmlObject(salaryTypeVO.getCostElement(), salaryTypeVO.getCostElementCode(), salaryTypeVO.getName(), budgetPeriodArray, salaryTypeVO.getTotal()));
            }
            this.setTotalForPeriodWise(salaryTypeList, budgetPeriodWiseTotalMap);
        }
        salaryTypeList.sort((salaryType1, salaryType2) -> {
            int i = 0;
            if (salaryType1.getCostElementCode() != null && salaryType2.getCostElementCode() != null) {
                i = salaryType1.getCostElementCode().compareTo(salaryType2.getCostElementCode());
            }
            return i;
        });
        return salaryTypeList;
    }

    private void setTotalForPeriodWise(List<SalaryType> salaryTypeList, Map<Integer, ScaleTwoDecimal> budgetPeriodWiseTotalMap) {
        BudgetPeriodData[] budgetPeriodArray = null;
        ScaleTwoDecimal budgetSalaryTotal = ScaleTwoDecimal.ZERO;
        if (!budgetPeriodWiseTotalMap.isEmpty()) {
            ArrayList<BudgetPeriodData> budgetPeriodList = new ArrayList<BudgetPeriodData>();
            for (Integer periodId : budgetPeriodWiseTotalMap.keySet()) {
                BudgetPeriodData budgetPeriodData = (BudgetPeriodData)BudgetPeriodData.Factory.newInstance();
                budgetPeriodData.setBudgetPeriodID(periodId);
                ScaleTwoDecimal periodCost = budgetPeriodWiseTotalMap.get(periodId);
                budgetPeriodData.setPeriodCost(periodCost.bigDecimalValue());
                budgetSalaryTotal = (ScaleTwoDecimal)budgetSalaryTotal.add((AbstractDecimal)periodCost);
                budgetPeriodList.add(budgetPeriodData);
            }
            budgetPeriodArray = budgetPeriodList.toArray(new BudgetPeriodData[0]);
        }
        salaryTypeList.add(this.getSalaryTypeXmlObject(null, null, PERIOD_COST_TOTAL, budgetPeriodArray, budgetSalaryTotal));
    }

    private ScaleTwoDecimal getTotalForCostElementOfAllPeriodsCost(List<BudgetDataPeriodVO> budgetDataPeriodVOs) {
        ScaleTwoDecimal total = ScaleTwoDecimal.ZERO;
        for (BudgetDataPeriodVO budgetDataPeriodVO : budgetDataPeriodVOs) {
            total = (ScaleTwoDecimal)total.add((AbstractDecimal)budgetDataPeriodVO.getPeriodCost());
        }
        return total;
    }

    private BudgetPeriodData[] getBudgetDataPeriodXmlObjects(List<BudgetDataPeriodVO> budgetDataPeriods, Map<Integer, ScaleTwoDecimal> budgetPeriodWiseTotalMap) {
        ArrayList<BudgetPeriodData> budgetPeriodList = new ArrayList<BudgetPeriodData>();
        for (BudgetDataPeriodVO budgetPeriodVO : budgetDataPeriods) {
            BudgetPeriodData budgetPeriodData = (BudgetPeriodData)BudgetPeriodData.Factory.newInstance();
            int budgetPeriodId = budgetPeriodVO.getBudgetPeriodId();
            budgetPeriodData.setBudgetPeriodID(budgetPeriodId);
            ScaleTwoDecimal periodCost = budgetPeriodVO.getPeriodCost();
            budgetPeriodData.setPeriodCost(periodCost.bigDecimalValue());
            if (budgetPeriodWiseTotalMap.containsKey(budgetPeriodId)) {
                ScaleTwoDecimal periodTotal = budgetPeriodWiseTotalMap.get(budgetPeriodId);
                periodTotal = (ScaleTwoDecimal)periodTotal.add((AbstractDecimal)periodCost);
                budgetPeriodWiseTotalMap.put(budgetPeriodId, periodTotal);
            } else {
                budgetPeriodWiseTotalMap.put(budgetPeriodId, periodCost);
            }
            budgetPeriodList.add(budgetPeriodData);
        }
        BudgetPeriodData[] budgetPeriodArray = budgetPeriodList.toArray(new BudgetPeriodData[0]);
        return budgetPeriodArray;
    }
}

