/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.impl.print.BudgetBaseSalaryStream;
import org.kuali.coeus.common.budget.impl.print.BudgetDataPeriodVO;
import org.kuali.coeus.common.budget.impl.print.SalaryTypeVO;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.printing.schema.BudgetSalaryDocument;
import org.kuali.kra.printing.schema.SalaryType;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="industrialCumBudgetXmlStream")
@Scope(value="prototype")
public class IndustrialCumBudgetXmlStream
extends BudgetBaseSalaryStream {
    private static final String CUM_INDSTRL_BUDGET = "Cumulative Industrial Budget";

    @Override
    public Map<String, BudgetSalaryDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, BudgetSalaryDocument> xmlObjectList = new LinkedHashMap<String, BudgetSalaryDocument>();
        this.budget = (Budget)printableBusinessObject;
        BudgetSalaryDocument budgetSalaryDocument = (BudgetSalaryDocument)BudgetSalaryDocument.Factory.newInstance();
        if (this.budget != null) {
            BudgetSalaryDocument.BudgetSalary budgetSalary = this.getBudgetSalary();
            budgetSalaryDocument.setBudgetSalary(budgetSalary);
        }
        xmlObjectList.put(CUM_INDSTRL_BUDGET, budgetSalaryDocument);
        return xmlObjectList;
    }

    private BudgetSalaryDocument.BudgetSalary getBudgetSalary() {
        BudgetSalaryDocument.BudgetSalary budgetSalary = this.getBudgetSalaryTypeXmlObject();
        budgetSalary.setHeaderTitle(CUM_INDSTRL_BUDGET);
        budgetSalary.setSalaryArray(this.getIndustrialCumBudgetSalaryTypes());
        return budgetSalary;
    }

    private SalaryType[] getIndustrialCumBudgetSalaryTypes() {
        ArrayList<SalaryTypeVO> salaryTypeVoList = new ArrayList<SalaryTypeVO>();
        HashMap<String, String> lineItems = new HashMap<String, String>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String budgetPeronnelCostEleDesc;
                if (budgetLineItem.getCostElementBO() == null || (budgetPeronnelCostEleDesc = budgetLineItem.getCostElementBO().getDescription()) == null || lineItems.containsKey(budgetPeronnelCostEleDesc) || budgetLineItem.getCostElementBO().getCostElement() == null) continue;
                lineItems.put(budgetPeronnelCostEleDesc, budgetLineItem.getCostElementBO().getCostElement());
            }
        }
        for (String costElemetDesc : lineItems.keySet()) {
            salaryTypeVoList.add(this.getSalaryTypeVOForCostElementForIndustrialCumBudget(costElemetDesc, (String)lineItems.get(costElemetDesc)));
        }
        List<SalaryType> salaryTypeList = this.getListOfSalaryTypeXmlObjects(salaryTypeVoList);
        return salaryTypeList.toArray(new SalaryType[0]);
    }

    private SalaryTypeVO getSalaryTypeVOForCostElementForIndustrialCumBudget(String costElemetDesc, String costElementCode) {
        SalaryTypeVO salaryTypeVO = new SalaryTypeVO();
        salaryTypeVO.setCostElement(costElemetDesc);
        salaryTypeVO.setCostElementCode(costElementCode);
        salaryTypeVO.setName(costElemetDesc);
        salaryTypeVO.setBudgetPeriodVOs(this.getBudgetDataPeriodVOsForCostElementForIndustrialCumBudget(costElementCode));
        return salaryTypeVO;
    }

    private List<BudgetDataPeriodVO> getBudgetDataPeriodVOsForCostElementForIndustrialCumBudget(String costElementCode) {
        ArrayList<BudgetDataPeriodVO> budgetPeriodDataList = new ArrayList<BudgetDataPeriodVO>();
        int budgetPeriodDataId = 0;
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            BudgetDataPeriodVO budgetDataPeriodVO = new BudgetDataPeriodVO();
            budgetDataPeriodVO.setBudgetPeriodId(++budgetPeriodDataId);
            ScaleTwoDecimal periodCost = ScaleTwoDecimal.ZERO;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!budgetLineItem.getCostElementBO().getCostElement().equals(costElementCode)) continue;
                periodCost = (ScaleTwoDecimal)periodCost.add((AbstractDecimal)budgetLineItem.getLineItemCost());
                periodCost = (ScaleTwoDecimal)periodCost.add((AbstractDecimal)this.getBudgetDataPeriodsForCalculatedAmountsForIndustrialCumBudget(budgetLineItem));
            }
            budgetDataPeriodVO.setPeriodCost(periodCost);
            budgetPeriodDataList.add(budgetDataPeriodVO);
        }
        return budgetPeriodDataList;
    }

    private ScaleTwoDecimal getBudgetDataPeriodsForCalculatedAmountsForIndustrialCumBudget(BudgetLineItem budgetLineItem) {
        ScaleTwoDecimal periodCost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            periodCost = (ScaleTwoDecimal)periodCost.add((AbstractDecimal)budgetLineItemCalcAmount.getCalculatedCost());
        }
        return periodCost;
    }
}

