/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.rate;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.kuali.coeus.common.budget.api.rate.TrainingStipendRateContract;
import org.kuali.coeus.common.budget.api.rate.TrainingStipendRateService;
import org.kuali.coeus.common.budget.framework.rate.TrainingStipendRate;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="trainingStipendRateService")
public class TrainingStipendRateServiceImpl
implements TrainingStipendRateService {
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    public TrainingStipendRateContract findClosestMatchTrainingStipendRate(Date effectiveDate, String careerLevel, int experienceLevel) {
        if (effectiveDate == null) {
            throw new IllegalArgumentException("effectiveDate is null");
        }
        if (StringUtils.isBlank((CharSequence)careerLevel)) {
            throw new IllegalArgumentException("careerLevel is null");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("careerLevel", careerLevel);
        criteria.put("experienceLevel", experienceLevel);
        Collection rates = CollectionUtils.emptyIfNull((Collection)this.businessObjectService.findMatchingOrderBy(TrainingStipendRate.class, criteria, "effectiveDate", false));
        for (TrainingStipendRate rate : rates) {
            if (rate.getEffectiveDate() == null) continue;
            LocalDate limit = LocalDate.fromDateFields((Date)effectiveDate);
            LocalDate rateDate = LocalDate.fromDateFields((Date)rate.getEffectiveDate());
            if (!rateDate.isBefore((ReadablePartial)limit) && !rateDate.isEqual((ReadablePartial)limit)) continue;
            return rate;
        }
        return null;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

