/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.print;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.custom.CustomDataUtils;
import org.kuali.coeus.common.framework.print.ReportBean;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.web.ui.Column;

public class CurrentReportBean
extends ReportBean {
    private String awardNumber;
    private String sponsorName;
    private String roleCode;
    private String awardTitle;
    private ScaleTwoDecimal awardAmount;
    private Date projectStartDate;
    private Date projectEndDate;
    private ScaleTwoDecimal academicYearEffort;
    private ScaleTwoDecimal calendarYearEffort;
    private ScaleTwoDecimal summerEffort;
    private ScaleTwoDecimal totalEffort;
    private String sponsorAwardNumber;
    private ScaleTwoDecimal totalDirectCostTotal;
    private ScaleTwoDecimal totalIndirectCostTotal;
    private List<AwardCustomData> awardCustomDataList;
    private ParameterService parameterService;

    public CurrentReportBean(AwardPerson awardPerson) {
        this.roleCode = awardPerson.getRoleCode();
        this.academicYearEffort = awardPerson.getAcademicYearEffort();
        this.calendarYearEffort = awardPerson.getCalendarYearEffort();
        this.summerEffort = awardPerson.getSummerEffort();
        this.totalEffort = awardPerson.getTotalEffort();
        Award award = awardPerson.getAward();
        this.awardNumber = award.getAwardNumber();
        this.sponsorName = award.getSponsorName();
        this.sponsorAwardNumber = award.getSponsorAwardNumber();
        this.awardTitle = award.getTitle();
        this.awardAmount = award.getObligatedTotal();
        this.projectStartDate = award.getAwardEffectiveDate();
        this.projectEndDate = award.findLatestFinalExpirationDate();
        this.parameterService = KcServiceLocator.getService(ParameterService.class);
        String directIndirectEnabledValue = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        for (AwardAmountInfo awardAmountInfo : award.getAwardAmountInfos()) {
            if (!directIndirectEnabledValue.equals("1")) continue;
            this.totalDirectCostTotal = awardAmountInfo.getObligatedTotalDirect();
            this.totalIndirectCostTotal = awardAmountInfo.getObligatedTotalIndirect();
        }
        this.awardCustomDataList = new ArrayList<AwardCustomData>();
        String customGroupName = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "CURRENT_PENDING_REPORT_GROUP_NAME");
        for (AwardCustomData awardcutomdata : award.getAwardCustomDataList()) {
            if (awardcutomdata.getCustomAttribute() == null || !awardcutomdata.getCustomAttribute().getGroupName().equals(customGroupName)) continue;
            this.awardCustomDataList.add(awardcutomdata);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrentReportBean)) {
            return false;
        }
        return this.awardNumber.equals(((CurrentReportBean)o).awardNumber);
    }

    public ScaleTwoDecimal getAcademicYearEffort() {
        return this.academicYearEffort;
    }

    public ScaleTwoDecimal getAwardAmount() {
        return this.awardAmount;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public String getAwardTitle() {
        return this.awardTitle;
    }

    public ScaleTwoDecimal getCalendarYearEffort() {
        return this.calendarYearEffort;
    }

    public Date getProjectEndDate() {
        return this.projectEndDate;
    }

    public Date getProjectStartDate() {
        return this.projectStartDate;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public ScaleTwoDecimal getSummerEffort() {
        return this.summerEffort;
    }

    public int hashCode() {
        return this.awardNumber.hashCode();
    }

    @Override
    protected List<Column> createColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(this.createColumn("Sponsor Award ID", "sponsorAwardNumber", this.sponsorAwardNumber, String.class));
        columns.add(this.createColumn("Sponsor", "sponsorName", this.sponsorName, String.class));
        columns.add(this.createColumn("Role", "roleCode", this.roleCode, String.class));
        columns.add(this.createColumn("Title", "awardTitle", this.awardTitle, String.class));
        String directIndirectEnabledValue = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        if (directIndirectEnabledValue.equals("1")) {
            columns.add(this.createColumn("Total Direct Cost", "totalDirectCostTotal", this.totalDirectCostTotal, ScaleTwoDecimal.class));
            columns.add(this.createColumn("Total F&A Cost", "totalIndirectCostTotal", this.totalIndirectCostTotal, ScaleTwoDecimal.class));
        }
        columns.add(this.createColumn("Award Amount", "awardAmount", this.awardAmount, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Effective Date", "projectStartDate", this.projectStartDate, Date.class));
        columns.add(this.createColumn("End Date", "projectEndDate", this.projectEndDate, Date.class));
        columns.add(this.createColumn("Effort %", "totalEffort", this.totalEffort, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Academic Year Effort %", "academicYearEffort", this.academicYearEffort, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Summer Effort %", "summerEffort", this.summerEffort, ScaleTwoDecimal.class));
        columns.add(this.createColumn("Calendar Year Effort %", "calendarYearEffort", this.calendarYearEffort, ScaleTwoDecimal.class));
        if (this.awardCustomDataList.size() > 0) {
            for (AwardCustomData awardCustomData : this.awardCustomDataList) {
                columns.add(this.createColumn(awardCustomData.getCustomAttribute().getLabel(), "awardCustomDataList", CustomDataUtils.getFormattedValueString(awardCustomData), String.class));
            }
        }
        return columns;
    }

    public void setTotalEffort(ScaleTwoDecimal totalEffort) {
        this.totalEffort = totalEffort;
    }

    public ScaleTwoDecimal getTotalEffort() {
        return this.totalEffort;
    }

    public void setSponsorAwardNumber(String sponsorAwardNumber) {
        this.sponsorAwardNumber = sponsorAwardNumber;
    }

    public String getSponsorAwardNumber() {
        return this.sponsorAwardNumber;
    }

    public void setTotalDirectCostTotal(ScaleTwoDecimal totalDirectCostTotal) {
        this.totalDirectCostTotal = totalDirectCostTotal;
    }

    public ScaleTwoDecimal getTotalDirectCostTotal() {
        return this.totalDirectCostTotal;
    }

    public void setTotalIndirectCostTotal(ScaleTwoDecimal totalIndirectCostTotal) {
        this.totalIndirectCostTotal = totalIndirectCostTotal;
    }

    public ScaleTwoDecimal getTotalIndirectCostTotal() {
        return this.totalIndirectCostTotal;
    }

    public void setAwardCustomDataList(List<AwardCustomData> awardCustomDataList) {
        this.awardCustomDataList = awardCustomDataList;
    }

    public List<AwardCustomData> getAwardCustomDataList() {
        return this.awardCustomDataList;
    }
}

