/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.print;

import java.lang.ref.WeakReference;
import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.attachment.KcAttachmentDataDao;
import org.kuali.coeus.sys.api.model.KcFile;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;

@MappedSuperclass
public abstract class KcAttachmentDataSource
extends KcPersistableBusinessObjectBase
implements KcFile {
    @Column(name="FILE_NAME")
    private String name;
    @Column(name="CONTENT_TYPE")
    private String type;
    @Column(name="FILE_DATA_ID")
    private String fileDataId;
    @Column(name="UPLOAD_USER")
    private String uploadUser;
    @Column(name="UPLOAD_TIMESTAMP")
    private Timestamp uploadTimestamp;
    @Transient
    private transient WeakReference<byte[]> data;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public byte[] getData() {
        byte[] existingData;
        if (this.data != null && (existingData = (byte[])this.data.get()) != null) {
            return existingData;
        }
        byte[] newData = this.getKcAttachmentDao().getData(this.fileDataId);
        this.data = new WeakReference<byte[]>(newData);
        return newData;
    }

    private KcAttachmentDataDao getKcAttachmentDao() {
        return KcServiceLocator.getService(KcAttachmentDataDao.class);
    }

    public String getFileDataId() {
        return this.fileDataId;
    }

    public void setFileDataId(String fileDataId) {
        this.fileDataId = fileDataId;
    }

    public void setData(byte[] data) {
        if (data == null) {
            this.getKcAttachmentDao().removeData(this.fileDataId);
        } else {
            this.fileDataId = this.getKcAttachmentDao().saveData(data, this.fileDataId);
        }
        this.data = new WeakReference<byte[]>(data);
    }

    public String getUploadUser() {
        return this.uploadUser;
    }

    public void setUploadUser(String uploadUser) {
        this.uploadUser = uploadUser;
    }

    public Timestamp getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public void setUploadTimestamp(Timestamp uploadTimestamp) {
        this.uploadTimestamp = uploadTimestamp;
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        if (StringUtils.isBlank((CharSequence)this.uploadUser)) {
            this.uploadUser = this.getUpdateUser();
        }
        if (this.uploadTimestamp == null) {
            this.uploadTimestamp = this.getUpdateTimestamp();
        }
    }

    @Override
    protected void preUpdate() {
        super.preUpdate();
        if (StringUtils.isBlank((CharSequence)this.uploadUser)) {
            this.uploadUser = this.getUpdateUser();
        }
        if (this.uploadTimestamp == null) {
            this.uploadTimestamp = this.getUpdateTimestamp();
        }
    }

    protected void postRemove() {
        super.postRemove();
        if (this.getFileDataId() != null) {
            this.getKcAttachmentDao().removeData(this.getFileDataId());
        }
    }
}

