/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.compliance.core;

import java.util.HashMap;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewApprovalType;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewType;
import org.kuali.coeus.common.framework.compliance.core.ValidSpecialReviewApproval;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class ValidSpecialReviewApprovalMaintenanceRule
extends KcMaintenanceDocumentRuleBase {
    private static final String SPECIAL_REVIEW_TYPE_CODE = "specialReviewTypeCode";
    private static final String SPECIAL_REVIEW_TYPE_TITLE = "Special Review Type Code";
    private static final String APPROVAL_TYPE_CODE = "approvalTypeCode";
    private static final String APPROVAL_TYPE_TITLE = "Approval Type Code";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        ValidSpecialReviewApproval specialReviewApproval = (ValidSpecialReviewApproval)document.getDocumentBusinessObject();
        return this.validate(specialReviewApproval);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        ValidSpecialReviewApproval specialReviewApproval = (ValidSpecialReviewApproval)document.getDocumentBusinessObject();
        return this.validate(specialReviewApproval);
    }

    private boolean validate(ValidSpecialReviewApproval specialReviewApproval) {
        boolean valid = true;
        HashMap<String, String> specialReviewTypePk = new HashMap<String, String>();
        specialReviewTypePk.put(SPECIAL_REVIEW_TYPE_CODE, specialReviewApproval.getSpecialReviewTypeCode());
        valid &= this.checkExistenceFromTable(SpecialReviewType.class, specialReviewTypePk, SPECIAL_REVIEW_TYPE_CODE, SPECIAL_REVIEW_TYPE_TITLE);
        HashMap<String, String> approvalTypePk = new HashMap<String, String>();
        approvalTypePk.put(APPROVAL_TYPE_CODE, specialReviewApproval.getApprovalTypeCode());
        return valid &= this.checkExistenceFromTable(SpecialReviewApprovalType.class, approvalTypePk, APPROVAL_TYPE_CODE, APPROVAL_TYPE_TITLE);
    }
}

