/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.multicampus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.kuali.coeus.common.framework.multicampus.MultiCampusIdentityService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.location.api.campus.Campus;
import org.kuali.rice.location.api.campus.CampusService;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;

public class MultiCampusDummyLoginFilter
implements Filter {
    private String loginPath;
    private boolean showPassword = false;
    private List<Campus> campuses;

    public void init(FilterConfig config) throws ServletException {
        this.loginPath = config.getInitParameter("loginPath");
        this.showPassword = Boolean.valueOf(config.getInitParameter("showPassword"));
        this.campuses = new ArrayList<Campus>(this.getCampusService().findAllCampuses());
        if (this.loginPath == null) {
            this.loginPath = "/WEB-INF/jsp/multicampus_dummy_login.jsp";
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest hsreq = (HttpServletRequest)request;
            UserSession session = null;
            if (hsreq.getSession().getAttribute("UserSession") != null) {
                session = (UserSession)hsreq.getSession().getAttribute("UserSession");
            }
            if (session == null) {
                IdentityService auth = this.getIdentityService();
                request.setAttribute("showPasswordField", (Object)this.showPassword);
                request.setAttribute("campuses", this.campuses);
                String user = request.getParameter("__login_user");
                String password = request.getParameter("__login_pw");
                String campusCode = request.getParameter("__login_campusCode");
                final String multiCampusUser = this.getMultiCampusIdentityService().getMultiCampusPrincipalName(user, campusCode);
                if (user != null) {
                    Principal principal;
                    Principal principal2 = principal = this.showPassword ? auth.getPrincipalByPrincipalNameAndPassword(multiCampusUser, password) : auth.getPrincipalByPrincipalName(multiCampusUser);
                    if (principal == null) {
                        this.handleInvalidLogin((ServletRequest)request, response);
                        return;
                    }
                    request = new HttpServletRequestWrapper(this, hsreq){

                        public String getRemoteUser() {
                            return multiCampusUser;
                        }
                    };
                    hsreq.getSession().setAttribute("userCampusCode", (Object)campusCode);
                } else {
                    request.getRequestDispatcher(this.loginPath).forward(request, response);
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    private void handleInvalidLogin(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        request.setAttribute("invalidAuth", (Object)Boolean.TRUE);
        request.getRequestDispatcher(this.loginPath).forward(request, response);
    }

    public void destroy() {
    }

    protected CampusService getCampusService() {
        return LocationApiServiceLocator.getCampusService();
    }

    protected MultiCampusIdentityService getMultiCampusIdentityService() {
        return KcServiceLocator.getService(MultiCampusIdentityService.class);
    }

    protected IdentityService getIdentityService() {
        return KimApiServiceLocator.getIdentityService();
    }
}

