/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.person.citi;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.attr.PersonTraining;
import org.kuali.coeus.common.framework.person.citi.CitiDataProcessingService;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiMap;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecord;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecordError;
import org.kuali.coeus.common.framework.person.citi.PersonTrainingCitiRecordStatus;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DictionaryValidationService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.KRADUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="citiDataProcessingService")
public class CitiDataProcessingServiceImpl
implements CitiDataProcessingService {
    private static final Logger LOG = LogManager.getLogger(CitiDataProcessingServiceImpl.class);
    private static final String STATUS_CODE = "statusCode";
    private static final String PERSON_ID = "personId";
    private static final String TRAINING_CODE = "trainingCode";
    private static final String DATE_REQUESTED = "dateRequested";
    private static final String DATE_SUBMITTED = "dateSubmitted";
    private static final String GROUP_ID = "groupId";
    private static final String STAGE_NUMBER = "stageNumber";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dictionaryValidationService")
    private DictionaryValidationService dictionaryValidationService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="identityService")
    private IdentityService identityService;

    @Override
    public void processRecords() {
        this.getBusinessObjectService().deleteMatching(PersonTrainingCitiRecordError.class, Collections.emptyMap());
        List mappings = this.getBusinessObjectService().findAll(PersonTrainingCitiMap.class);
        List sourceRecords = this.getBusinessObjectService().findMatching(PersonTrainingCitiRecord.class, Collections.singletonMap(STATUS_CODE, Stream.of(PersonTrainingCitiRecordStatus.STAGED.getCode(), PersonTrainingCitiRecordStatus.ERRORED.getCode()).collect(Collectors.toList())));
        sourceRecords.forEach(sr -> {
            Principal principal;
            PersonTrainingCitiMap mapping;
            Optional<PersonTrainingCitiMap> optionalMapping;
            this.resetErroredStatus((PersonTrainingCitiRecord)sr);
            List<PersonTrainingCitiRecordError> errors = this.validateCitiRecord((PersonTrainingCitiRecord)sr);
            if (CollectionUtils.isNotEmpty(errors)) {
                this.addErrors((PersonTrainingCitiRecord)sr, errors.toArray(new PersonTrainingCitiRecordError[errors.size()]));
            }
            if (!(optionalMapping = mappings.stream().filter(m -> m.getGroupId().equals(sr.getGroupId()) && m.getStageNumber().equals(sr.getStageNumber())).findFirst()).isPresent()) {
                mapping = this.createAndSaveEmptyMapping((PersonTrainingCitiRecord)sr);
                mappings.add(mapping);
            } else {
                mapping = optionalMapping.get();
            }
            if (mapping.getTrainingCode() == null) {
                this.addErrors((PersonTrainingCitiRecord)sr, new PersonTrainingCitiRecordError("groupId=" + sr.getGroupId() + " stageNumber=" + sr.getStageNumber() + " is not mapped to a trainingCode"));
            }
            Principal principal2 = principal = StringUtils.isNotBlank((CharSequence)sr.getInstitutionalUsername()) ? this.getIdentityService().getPrincipalByPrincipalName(sr.getInstitutionalUsername()) : null;
            if (principal == null) {
                this.addErrors((PersonTrainingCitiRecord)sr, new PersonTrainingCitiRecordError("principal id not found from institutional username " + sr.getInstitutionalUsername()));
            }
            if (!PersonTrainingCitiRecordStatus.ERRORED.getCode().equals(sr.getStatusCode())) {
                sr.setStatusCode(PersonTrainingCitiRecordStatus.PROCESSED.getCode());
                this.getBusinessObjectService().save((PersistableBusinessObject)this.createOrUpdatePersonTraining((PersonTrainingCitiRecord)sr, mapping, principal));
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)sr);
        });
        if (LOG.isInfoEnabled()) {
            int errors = this.getBusinessObjectService().countMatching(PersonTrainingCitiRecord.class, Map.of(STATUS_CODE, PersonTrainingCitiRecordStatus.ERRORED.getCode()));
            int processed = this.getBusinessObjectService().countMatching(PersonTrainingCitiRecord.class, Map.of(STATUS_CODE, PersonTrainingCitiRecordStatus.PROCESSED.getCode()));
            LOG.info("Finished processing citi records.  Errors: " + errors + ", Processed: " + processed);
        }
    }

    protected PersonTrainingCitiMap createAndSaveEmptyMapping(PersonTrainingCitiRecord sr) {
        PersonTrainingCitiMap newMapping = new PersonTrainingCitiMap();
        newMapping.setGroupId(sr.getGroupId());
        newMapping.setStageNumber(sr.getStageNumber());
        if (StringUtils.isNotBlank((CharSequence)newMapping.getGroupId()) && StringUtils.isNotBlank((CharSequence)newMapping.getStageNumber())) {
            return (PersonTrainingCitiMap)this.getBusinessObjectService().save((PersistableBusinessObject)newMapping);
        }
        return newMapping;
    }

    protected PersonTraining createOrUpdatePersonTraining(PersonTrainingCitiRecord sr, PersonTrainingCitiMap mapping, Principal principal) {
        String personId = principal.getPrincipalId();
        Integer trainingCode = mapping.getTrainingCode();
        Timestamp dateRequested = sr.getRegistrationDate();
        Timestamp dateSubmitted = sr.getDateCompleted();
        PersonTraining pt = this.findPersonTraining(personId, trainingCode, dateRequested, dateSubmitted);
        pt.setPersonId(personId);
        pt.setTrainingCode(trainingCode);
        pt.setActive(true);
        pt.setScore(sr.getScore());
        pt.setTrainingNumber(-1);
        pt.setDateRequested(dateRequested);
        pt.setDateSubmitted(dateSubmitted);
        pt.setFollowupDate(sr.getExpirationDate());
        return pt;
    }

    protected PersonTraining findPersonTraining(String personId, Integer trainingCode, Timestamp dateRequested, Timestamp dateSubmitted) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put(PERSON_ID, personId);
        criteria.put(TRAINING_CODE, trainingCode);
        criteria.put(DATE_REQUESTED, dateRequested);
        criteria.put(DATE_SUBMITTED, dateSubmitted);
        List existingTrainings = this.getBusinessObjectService().findMatching(PersonTraining.class, criteria);
        if (!existingTrainings.isEmpty()) {
            return (PersonTraining)existingTrainings.iterator().next();
        }
        return new PersonTraining();
    }

    protected List<PersonTrainingCitiRecordError> validateCitiRecord(PersonTrainingCitiRecord sr) {
        this.globalVariableService.getMessageMap().clearErrorMessages();
        this.dictionaryValidationService.validateBusinessObject((Object)sr, true);
        return this.globalVariableService.getMessageMap().getErrorMessages().values().stream().flatMap(Collection::stream).map(message -> new PersonTrainingCitiRecordError(KRADUtils.getMessageText((ErrorMessage)message, (boolean)false))).collect(Collectors.toList());
    }

    protected void addErrors(PersonTrainingCitiRecord sr, PersonTrainingCitiRecordError ... errors) {
        sr.setStatusCode(PersonTrainingCitiRecordStatus.ERRORED.getCode());
        Stream.of(errors).forEach(sr::addError);
    }

    protected void resetErroredStatus(PersonTrainingCitiRecord sr) {
        if (PersonTrainingCitiRecordStatus.ERRORED.getCode().equals(sr.getStatusCode())) {
            sr.setStatusCode(PersonTrainingCitiRecordStatus.STAGED.getCode());
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }
}

