/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.proposal.impl.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kuali.coeus.common.framework.print.CurrentReportBean;
import org.kuali.coeus.common.framework.version.history.VersionHistory;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.proposal.impl.report.BaseReportDaoOjb;
import org.kuali.coeus.common.proposal.impl.report.CurrentReportDao;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.DocumentBase;
import org.springframework.stereotype.Component;

@Component(value="currentReportDao")
public class CurrentReportDaoOjb
extends BaseReportDaoOjb
implements CurrentReportDao {
    private VersionHistoryService versionHistoryService;

    @Override
    public List<CurrentReportBean> queryForCurrentSupport(String personId) throws WorkflowException {
        ArrayList<CurrentReportBean> data = new ArrayList<CurrentReportBean>();
        for (AwardPerson awardPerson : this.executeCurrentSupportQuery(personId)) {
            this.lazyLoadAward(awardPerson);
            CurrentReportBean bean = this.buildReportBean(awardPerson);
            if (bean == null) continue;
            data.add(bean);
        }
        return data;
    }

    private CurrentReportBean buildReportBean(AwardPerson awardPerson) throws WorkflowException {
        Award award = awardPerson.getAward();
        CurrentReportBean bean = null;
        if (this.shouldDataBeIncluded((DocumentBase)award.getAwardDocument()) && award.isActiveVersion() && Objects.equals(this.getActiveAwardVersionSequenceNumber(award.getAwardNumber()), award.getSequenceNumber())) {
            bean = new CurrentReportBean(awardPerson);
        }
        return bean;
    }

    private Collection<AwardPerson> executeCurrentSupportQuery(String personId) {
        return this.getBusinessObjectService().findMatching(AwardPerson.class, Collections.singletonMap("personId", personId));
    }

    private void lazyLoadAward(AwardPerson awardPerson) {
        if (awardPerson.getAward() == null) {
            Map<String, Object> searchParms = CollectionUtils.zipMap(new String[]{"awardNumber", "sequenceNumber"}, new Object[]{awardPerson.getAwardNumber(), awardPerson.getSequenceNumber()});
            Award award = (Award)this.getBusinessObjectService().findMatching(Award.class, searchParms).iterator().next();
            awardPerson.setAward(award);
        }
    }

    private VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = KcServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }

    private Integer getActiveAwardVersionSequenceNumber(String awardNumber) {
        Integer retval = null;
        VersionHistory versionHistory = this.getVersionHistoryService().findActiveVersion(Award.class, awardNumber);
        if (versionHistory != null) {
            retval = versionHistory.getSequenceOwnerSequenceNumber();
        }
        return retval;
    }
}

