/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.util;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class EnvironmentUtil {
    private static EnvironmentUtil environmentUtil;
    public static final String APPLICATION_URL = "application.url";
    public static final String APPLICATION_ENV_SBX_REGEX = "application.environment.sbx.regex";
    public static final String APPLICATION_ENV_STG_REGEX = "application.environment.stg.regex";
    public static final String APPLICATION_ENV_TST_REGEX = "application.environment.tst.regex";
    public static final String APPLICATION_ENV_DEMO_REGEX = "application.environment.demo.regex";
    public static final String SBX_TEXT = "Sandbox Environment";
    public static final String STG_TEXT = "Staging Environment";
    public static final String TST_TEXT = "Testing Environment";
    public static final String DEMO_TEXT = "Demo Environment";
    private String environmentText = "";
    private ConfigurationService configurationService;
    private ParameterService parameterService;

    public static EnvironmentUtil getInstance() {
        if (environmentUtil == null) {
            environmentUtil = new EnvironmentUtil();
        }
        return environmentUtil;
    }

    public EnvironmentUtil() {
        HashMap<String, String> environmentsMap = new HashMap<String, String>();
        String applicationUrl = this.getConfigurationService().getPropertyValueAsString(APPLICATION_URL);
        environmentsMap.put(APPLICATION_ENV_SBX_REGEX, SBX_TEXT);
        environmentsMap.put(APPLICATION_ENV_STG_REGEX, STG_TEXT);
        environmentsMap.put(APPLICATION_ENV_TST_REGEX, TST_TEXT);
        environmentsMap.put(APPLICATION_ENV_DEMO_REGEX, DEMO_TEXT);
        environmentsMap.forEach((regexProperty, text) -> {
            if (Pattern.matches(this.getConfigurationService().getPropertyValueAsString(regexProperty), applicationUrl)) {
                this.setEnvironmentText((String)text);
            }
        });
    }

    public String getEnvironmentText() {
        return this.isEnvironmentBannerEnabled() ? this.environmentText : "";
    }

    public void setEnvironmentText(String environmentText) {
        this.environmentText = environmentText;
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected boolean isEnvironmentBannerEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "Environment_Banner_Enabled", Boolean.valueOf(true));
    }
}

