/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.org.kuali.rice.krad.uif.lifecycle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.View;

public class KcAssignIdsTask
extends ViewLifecycleTaskBase<LifecycleElement> {
    private static final Pattern DIALOGS_PATTERN = Pattern.compile("dialogs\\[([0-9]+?)\\]");

    public KcAssignIdsTask() {
        super(LifecycleElement.class);
    }

    public static String generateId(LifecycleElement element, View view) {
        int prime = 6971;
        int hash = element.getClass().getName().hashCode();
        hash += prime;
        if (element.getViewPath() != null) {
            hash += element.getViewPath().hashCode();
        }
        if (element.getViewPath() != null && element.getViewPath().startsWith("dialogs[")) {
            Component parentDialog;
            Matcher matcher = DIALOGS_PATTERN.matcher(element.getViewPath());
            int index = -1;
            matcher.find();
            String strIndex = matcher.group(1);
            if (StringUtils.isNotBlank((CharSequence)strIndex)) {
                index = Integer.valueOf(strIndex);
            }
            if (view.getDialogs() != null && index > -1 && index < view.getDialogs().size() && (parentDialog = (Component)view.getDialogs().get(index)) != null && StringUtils.isNotBlank((CharSequence)parentDialog.getId())) {
                hash += parentDialog.getId().hashCode();
            }
        }
        String id = Long.toString((long)hash - Integer.MIN_VALUE, 36);
        while (!view.getViewIndex().observeAssignedId(id)) {
            id = Long.toString((long)(hash *= 4507) - Integer.MIN_VALUE, 36);
        }
        return "u" + id;
    }

    protected void performLifecycleTask() {
        LifecycleElement element = this.getElementState().getElement();
        if (StringUtils.isBlank((CharSequence)element.getId())) {
            element.setId(KcAssignIdsTask.generateId(element, ViewLifecycle.getView()));
        }
    }
}

