/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.ProposalDevelopmentProposalAttachmentsAuditRule;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalAttachmentSubmitToSponsorRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    public static final String ATTACHMENTS_AUDIT_CLUSTER_KEY = "proposalAttachmentsAuditWarnings";
    private static final String AUDIT_PARM = "AUDIT_INCOMPLETE_PROPOSAL_ATTACHMENTS";
    private static final String AUDIT_PARAMETER_VALUE_NO = "N";
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentProposalAttachmentsAuditRule.class);
    private ParameterService parameterService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)document).getDevelopmentProposal();
        return valid &= this.validateIncompleteAttachments(developmentProposal);
    }

    private boolean validateIncompleteAttachments(DevelopmentProposal developmentProposal) {
        boolean valid = true;
        Parameter attachmentAuditParam = this.getParameterService().getParameter(ProposalDevelopmentDocument.class, AUDIT_PARM);
        if (attachmentAuditParam == null) {
            LOG.warn("System parameter AUDIT_INCOMPLETE_PROPOSAL_ATTACHMENTS is missing or invalid");
            throw new RuntimeException("System parameter AUDIT_INCOMPLETE_PROPOSAL_ATTACHMENTS is missing or invalid");
        }
        String auditIncompleteAttachments = attachmentAuditParam.getValue();
        if (auditIncompleteAttachments.equals(AUDIT_PARAMETER_VALUE_NO)) {
            List<Narrative> narratives = developmentProposal.getNarratives();
            int narrativeIndex = 0;
            for (Narrative narrative : narratives) {
                if (narrative.getModuleStatusCode().equals("I")) {
                    this.getAuditErrors().add(new AuditError("document.developmentProposalList[0].narrative[" + narrativeIndex + "].moduleStatusCode", "error.document.narrativestatuscode.not.complete", "abstractsAttachments"));
                    valid &= false;
                }
                ++narrativeIndex;
            }
        }
        return valid;
    }

    private List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!GlobalVariables.getAuditErrorMap().containsKey(ATTACHMENTS_AUDIT_CLUSTER_KEY)) {
            GlobalVariables.getAuditErrorMap().put(ATTACHMENTS_AUDIT_CLUSTER_KEY, new AuditCluster("Abstracts and Attachments", auditErrors, "Error"));
        } else {
            auditErrors = ((AuditCluster)GlobalVariables.getAuditErrorMap().get(ATTACHMENTS_AUDIT_CLUSTER_KEY)).getAuditErrorList();
        }
        return auditErrors;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

