/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetNavigationService;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.uif.element.Action;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalBudgetNavigationService")
public class ProposalBudgetNavigationServiceImpl
implements ProposalBudgetNavigationService {
    private static final String READY_GENERATE_PERIOD = "readyGeneratePeriod";
    private static final String SINGLE_POINT_ENTRY_FLAG = "SINGLE_POINT_ENTRY_FLAG";
    private static final String STANDALONE_MODULAR_BUDGET_BASE_URL_CONFIG_PARAM = "budget.modular.standalone.base.url";
    private static final String STANDALONE_BUDGET_BASE_URL_CONFIG_PARAM = "budget.standalone.base.url";
    @Autowired
    @Qualifier(value="budgetSummaryService")
    private BudgetSummaryService budgetSummaryService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;

    @Override
    public void createNavigationLink(Action action, ProposalBudgetForm form, String direction) {
        String navigateToPageId = "";
        String methodToCall = "";
        String pageId = form.getPageId();
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            pageId = "PropBudget-PeriodsPage";
        }
        boolean next = StringUtils.equals((CharSequence)direction, (CharSequence)"next");
        switch (pageId) {
            case "PropBudget-PeriodsPage": {
                navigateToPageId = next ? this.getPeriodsPageNextPageId(form) : "";
                break;
            }
            case "PropBudget-RatesPage": {
                navigateToPageId = next ? this.getRatesPageNextPageId(form) : "PropBudget-PeriodsPage";
                break;
            }
            case "PropBudget-ProjectPersonnelPage": {
                navigateToPageId = next ? "PropBudget-AssignPersonnelToPeriodsPage" : "PropBudget-PeriodsPage";
                break;
            }
            case "PropBudget-AssignPersonnelToPeriodsPage": {
                navigateToPageId = next ? "PropBudget-NonPersonnelCostsPage" : "PropBudget-ProjectPersonnelPage";
                break;
            }
            case "PropBudget-NonPersonnelCostsPage": {
                if (this.isSinglePointEntry()) {
                    navigateToPageId = next ? "PropBudget-SinglePointEntryPage" : "PropBudget-AssignPersonnelToPeriodsPage";
                    break;
                }
                navigateToPageId = next ? (this.canGeneratePeriods(form) ? "" : "PropBudget-SubawardsPage") : "PropBudget-AssignPersonnelToPeriodsPage";
                methodToCall = next && this.canGeneratePeriods(form) ? READY_GENERATE_PERIOD : "";
                break;
            }
            case "PropBudget-SinglePointEntryPage": {
                navigateToPageId = next ? (this.canGeneratePeriods(form) ? "" : "PropBudget-SubawardsPage") : "PropBudget-NonPersonnelCostsPage";
                methodToCall = next && this.canGeneratePeriods(form) ? READY_GENERATE_PERIOD : "";
                break;
            }
            case "PropBudget-SubawardsPage": {
                navigateToPageId = next ? this.getSubawardNextPageId(form) : this.getSubawardPreviousPageId(form);
                break;
            }
            case "PropBudget-CostSharingPage": {
                navigateToPageId = next ? this.getCostShareNextPageId(form) : this.getCostSharePreviousPageId(form);
                break;
            }
            case "PropBudget-UnrecoveredFandAPage": {
                navigateToPageId = next ? this.getUnrecoveredNextPageId(form) : this.getUnrecoveredPreviousPageId(form);
                break;
            }
            case "PropBudget-ProjectIncomePage": {
                navigateToPageId = next ? "PropBudget-SummaryPage" : this.getModularPreviousPageId(form);
                break;
            }
            case "PropBudget-ModularPage": {
                navigateToPageId = next ? "PropBudget-SummaryPage" : this.getModularPreviousPageId(form);
                break;
            }
            case "PropBudget-NotesPage": {
                navigateToPageId = next ? "PropBudget-SummaryPage" : this.getOtherPreviousPageId(form);
                break;
            }
            case "PropBudget-SummaryPage": {
                navigateToPageId = next ? "" : this.getOtherPreviousPageId(form);
            }
        }
        this.createAction(action, navigateToPageId, methodToCall);
    }

    protected void createAction(Action action, String navigateToPageId, String methodToCall) {
        if (StringUtils.isNotEmpty((CharSequence)methodToCall)) {
            action.setMethodToCall(methodToCall);
        }
        if (StringUtils.isNotEmpty((CharSequence)navigateToPageId)) {
            action.getActionParameters().put("navigateToPageId", navigateToPageId);
        }
        if (StringUtils.isEmpty((CharSequence)navigateToPageId) && StringUtils.isEmpty((CharSequence)methodToCall)) {
            action.setRender(false);
        }
    }

    protected boolean canGeneratePeriods(ProposalBudgetForm form) {
        if (!form.getBudget().getBudgetPeriods().isEmpty() && form.getBudget().getBudgetPeriod(0).getBudgetLineItems().isEmpty()) {
            return false;
        }
        for (int i = 1; i < form.getBudget().getBudgetPeriods().size(); ++i) {
            if (!this.getBudgetSummaryService().budgetLineItemExists(form.getBudget(), i)) continue;
            return false;
        }
        return true;
    }

    protected String getPeriodsPageNextPageId(ProposalBudgetForm form) {
        if (!form.getBudget().getBudgetLineItems().isEmpty()) {
            return "PropBudget-ProjectPersonnelPage";
        }
        if (form.isCostSharingEditFormVisible()) {
            return "PropBudget-CostSharingPage";
        }
        if (form.isUnrecoveredFandAEditFormVisible()) {
            return "PropBudget-UnrecoveredFandAPage";
        }
        if (form.getBudget().getModularBudgetFlag().booleanValue() && !this.isStandaloneModularBudgetEnabled()) {
            return "PropBudget-ModularPage";
        }
        return "PropBudget-SummaryPage";
    }

    protected String getRatesPageNextPageId(ProposalBudgetForm form) {
        if (!form.getBudget().getBudgetLineItems().isEmpty()) {
            return "PropBudget-ProjectPersonnelPage";
        }
        return "PropBudget-SummaryPage";
    }

    protected String getSubawardNextPageId(ProposalBudgetForm form) {
        if (form.isCostSharingEditFormVisible()) {
            return "PropBudget-CostSharingPage";
        }
        if (form.isUnrecoveredFandAEditFormVisible()) {
            return "PropBudget-UnrecoveredFandAPage";
        }
        if (form.getBudget().getModularBudgetFlag().booleanValue() && !this.isStandaloneModularBudgetEnabled()) {
            return "PropBudget-ModularPage";
        }
        return "PropBudget-SummaryPage";
    }

    protected String getSubawardPreviousPageId(ProposalBudgetForm form) {
        if (!form.getBudget().getBudgetLineItems().isEmpty()) {
            return this.isSinglePointEntry() ? "PropBudget-SinglePointEntryPage" : "PropBudget-NonPersonnelCostsPage";
        }
        return "PropBudget-PeriodsPage";
    }

    protected String getCostShareNextPageId(ProposalBudgetForm form) {
        if (form.isUnrecoveredFandAEditFormVisible()) {
            return "PropBudget-UnrecoveredFandAPage";
        }
        if (form.getBudget().getModularBudgetFlag().booleanValue() && !this.isStandaloneModularBudgetEnabled()) {
            return "PropBudget-ModularPage";
        }
        return "PropBudget-SummaryPage";
    }

    protected String getCostSharePreviousPageId(ProposalBudgetForm form) {
        if (!form.getBudget().getBudgetLineItems().isEmpty()) {
            return "PropBudget-SubawardsPage";
        }
        return "PropBudget-PeriodsPage";
    }

    protected String getUnrecoveredNextPageId(ProposalBudgetForm form) {
        if (form.getBudget().getModularBudgetFlag().booleanValue() && !this.isStandaloneModularBudgetEnabled()) {
            return "PropBudget-ModularPage";
        }
        return "PropBudget-SummaryPage";
    }

    protected String getUnrecoveredPreviousPageId(ProposalBudgetForm form) {
        if (form.isCostSharingEditFormVisible()) {
            return "PropBudget-CostSharingPage";
        }
        if (!form.getBudget().getBudgetLineItems().isEmpty()) {
            return "PropBudget-SubawardsPage";
        }
        return "PropBudget-PeriodsPage";
    }

    protected String getModularPreviousPageId(ProposalBudgetForm form) {
        if (form.isUnrecoveredFandAEditFormVisible()) {
            return "PropBudget-UnrecoveredFandAPage";
        }
        if (form.isCostSharingEditFormVisible()) {
            return "PropBudget-CostSharingPage";
        }
        if (!form.getBudget().getBudgetLineItems().isEmpty()) {
            return "PropBudget-SubawardsPage";
        }
        return "PropBudget-PeriodsPage";
    }

    protected String getOtherPreviousPageId(ProposalBudgetForm form) {
        if (form.getBudget().getModularBudgetFlag().booleanValue() && !this.isStandaloneModularBudgetEnabled()) {
            return "PropBudget-ModularPage";
        }
        if (form.isUnrecoveredFandAEditFormVisible()) {
            return "PropBudget-UnrecoveredFandAPage";
        }
        if (form.isCostSharingEditFormVisible()) {
            return "PropBudget-CostSharingPage";
        }
        if (!form.getBudget().getBudgetLineItems().isEmpty()) {
            return "PropBudget-SubawardsPage";
        }
        return "PropBudget-PeriodsPage";
    }

    public boolean isSinglePointEntry() {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", SINGLE_POINT_ENTRY_FLAG);
    }

    public boolean isStandaloneModularBudgetEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-B", "All", "Standalone_Modular_Budget_Enabled", Boolean.valueOf(false));
    }

    @Override
    public String getStandaloneBudgetUrl(DevelopmentProposal proposal) {
        return this.getStandaloneBudgetBaseUrl() + "/budget/new?proposal_id=" + proposal.getProposalNumber();
    }

    @Override
    public String getStandaloneBudgetBaseUrl() {
        return this.configurationService.getPropertyValueAsString(STANDALONE_BUDGET_BASE_URL_CONFIG_PARAM);
    }

    @Override
    public String getStandaloneModularBudgetBaseUrl() {
        String budgetBaseUrl = this.configurationService.getPropertyValueAsString(STANDALONE_MODULAR_BUDGET_BASE_URL_CONFIG_PARAM);
        if (StringUtils.isBlank((CharSequence)budgetBaseUrl)) {
            budgetBaseUrl = this.configurationService.getPropertyValueAsString("application.url");
        }
        return budgetBaseUrl;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

