/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.datavalidation;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetViewHelperServiceImpl;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="proposalBudgetDataValidationController")
@RequestMapping(value={"/proposalBudget"})
public class ProposalBudgetDataValidationController
extends ProposalBudgetControllerBase {
    @Transactional
    @RequestMapping(params={"methodToCall=validateData"})
    public ModelAndView validateData(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        this.setDataValidation(form);
        return this.getModelAndViewService().showDialog("DataValidationSection", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=toggleValidation"})
    public ModelAndView toggleValidation(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        form.setAuditActivated(!form.isAuditActivated());
        this.setDataValidation(form);
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    protected void setDataValidation(ProposalBudgetForm form) {
        if (form.isAuditActivated()) {
            form.setDataValidationItems(((ProposalBudgetViewHelperServiceImpl)form.getViewHelperService()).populateDataValidation(form));
        }
    }

    @Transactional
    @RequestMapping(params={"methodToCall=navigateToError"})
    public ModelAndView navigateToError(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ((ProposalBudgetViewHelperServiceImpl)form.getViewHelperService()).applyBudgetAuditRules(form);
        form.setAjaxReturnType("update-page");
        String pageId = form.getActionParamaterValue("navigateToPageId");
        if (StringUtils.equals((CharSequence)pageId, (CharSequence)BudgetConstants.BudgetAuditRules.BUDGET_SETTINGS.getPageId())) {
            return this.getModelAndViewService().showDialog(BudgetConstants.BudgetAuditRules.BUDGET_SETTINGS.getPageId(), true, (UifFormBase)form);
        }
        return this.getNavigationControllerService().navigate((UifFormBase)form);
    }
}

