/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.editable;

import java.util.HashMap;
import java.util.Map;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetColumnsToAlter;
import org.kuali.coeus.sys.framework.persistence.KcPersistenceStructureService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaNumericValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AlphaValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.AnyCharacterValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.fieldlevel.DateValidationPattern;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;

public class BudgetColumnsToAlterMaintainableImpl
extends KraMaintainableImpl {
    private static final String STRING = "STRING";
    private static final String DATE = "DATE";
    private static final String NUMBER = "NUMBER";
    private static final String DOCUMENT_NEW_MAINTAINABLE_OBJECT_COLUMN_NAME = "document.newMaintainableObject.columnName";
    private static final String ERROR_PROPOSALCOLUMNSTOALTER_ATTRIBUTE_NOT_FOUND = "error.proposalcolumnstoalter.attributeNotFound";
    private static final Map<Class<? extends ValidationPattern>, String> VALIDATION_CLASSES_MAP = new HashMap<Class<? extends ValidationPattern>, String>();
    private transient KcPersistenceStructureService kcPersistenceStructureService;

    @Override
    public void prepareForSave() {
        super.prepareForSave();
        BudgetColumnsToAlter budgetCol = (BudgetColumnsToAlter)this.businessObject;
        Map<String, String> columnToAttrMap = this.getKcPersistenceStructureService().getDBColumnToObjectAttributeMap(Budget.class);
        AttributeDefinition attrDefinition = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(Budget.class.getName()).getAttributeDefinition(columnToAttrMap.get(budgetCol.getColumnName()));
        if (attrDefinition == null) {
            this.getGlobalVariableService().getMessageMap().putError(DOCUMENT_NEW_MAINTAINABLE_OBJECT_COLUMN_NAME, ERROR_PROPOSALCOLUMNSTOALTER_ATTRIBUTE_NOT_FOUND, new String[0]);
        } else {
            String dataType;
            if (attrDefinition.getLabel().length() > 30) {
                budgetCol.setColumnLabel(attrDefinition.getLabel().substring(0, 29));
            } else {
                budgetCol.setColumnLabel(attrDefinition.getLabel());
            }
            budgetCol.setDataLength(attrDefinition.getMaxLength());
            if (attrDefinition.getValidationPattern() != null) {
                Class<?> validationPattern = attrDefinition.getValidationPattern().getClass();
                dataType = VALIDATION_CLASSES_MAP.get(validationPattern);
                if (dataType == null) {
                    dataType = STRING;
                }
            } else {
                dataType = STRING;
            }
            budgetCol.setDataType(dataType);
        }
    }

    protected KcPersistenceStructureService getKcPersistenceStructureService() {
        if (this.kcPersistenceStructureService == null) {
            this.kcPersistenceStructureService = KcServiceLocator.getService(KcPersistenceStructureService.class);
        }
        return this.kcPersistenceStructureService;
    }

    static {
        VALIDATION_CLASSES_MAP.put(AnyCharacterValidationPattern.class, STRING);
        VALIDATION_CLASSES_MAP.put(AlphaNumericValidationPattern.class, STRING);
        VALIDATION_CLASSES_MAP.put(AlphaValidationPattern.class, STRING);
        VALIDATION_CLASSES_MAP.put(DateValidationPattern.class, DATE);
        VALIDATION_CLASSES_MAP.put(NumericValidationPattern.class, NUMBER);
    }
}

