/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.gf;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.impl.gf.GrantForwardAmount;
import org.kuali.coeus.propdev.impl.gf.GrantForwardDeadline;
import org.kuali.coeus.propdev.impl.gf.GrantForwardLocation;
import org.kuali.coeus.propdev.impl.gf.GrantForwardSponsor;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name="GRANT_FORWARD_RECORD")
public class GrantForwardRecord
extends KcPersistableBusinessObjectBase {
    @PortableSequenceGenerator(name="SEQ_GF_RECORD_ID")
    @GeneratedValue(generator="SEQ_GF_RECORD_ID")
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="PROPOSAL_NUMBER")
    private String proposalNumber;
    @Column(name="GRANT_ID")
    private Integer grantId;
    @Column(name="URL")
    private String url;
    @Column(name="AMOUNT_INFO")
    private String amountInfo;
    @Column(name="SITE_GRANT_TYPE")
    private String siteGrantType;
    @Column(name="MODIFIED_DATE")
    private String modifiedDate;
    @Column(name="APPLICATION_URL")
    private String applicationUrl;
    @Column(name="TITLE")
    private String title;
    @Column(name="EXT_GRANT_ID")
    private String extGrantId;
    @Column(name="ALL_TITLES")
    private String allTitles;
    @Column(name="SUBMISSION_INFO")
    private String submissionInfo;
    @Column(name="ALL_GRANT_SOURCE_URLS")
    private String allGrantSourceUrls;
    @Column(name="STATUS")
    private String status;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="ELIGIBILITY")
    private String eligibility;
    @Column(name="CATEGORIES_DISPLAY")
    private String categoriesDisplay;
    @Column(name="LIMITED_GRANT_INFO")
    private String limitedGrantInfo;
    @Column(name="REPLACES")
    private String replaces;
    @Column(name="USER_CATEGORIES")
    private String userCategories;
    @Column(name="SUBMIT_DATE")
    private String submitDate;
    @Column(name="IS_LIMITED")
    private Integer isLimited;
    @Column(name="SITE_CATEGORIES")
    private String siteCategories;
    @Column(name="COST_SHARING")
    private String costSharing;
    @Column(name="GRANT_SOURCE_URL")
    private String grantSourceUrl;
    @Column(name="ALL_TYPES")
    private String allTypes;
    @Column(name="ALL_APPLICANT_TYPES")
    private String allApplicantTypes;
    @OneToMany(mappedBy="grantForwardRecord", cascade={CascadeType.ALL})
    private List<GrantForwardDeadline> deadlines = new ArrayList<GrantForwardDeadline>();
    @OneToMany(mappedBy="grantForwardRecord", cascade={CascadeType.ALL})
    private List<GrantForwardAmount> amounts = new ArrayList<GrantForwardAmount>();
    @OneToMany(mappedBy="grantForwardRecord", cascade={CascadeType.ALL})
    private List<GrantForwardLocation> locations = new ArrayList<GrantForwardLocation>();
    @OneToMany(mappedBy="grantForwardRecord", cascade={CascadeType.ALL})
    private List<GrantForwardSponsor> sponsors = new ArrayList<GrantForwardSponsor>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public Integer getGrantId() {
        return this.grantId;
    }

    public void setGrantId(Integer grantId) {
        this.grantId = grantId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAmountInfo() {
        return this.amountInfo;
    }

    public void setAmountInfo(String amountInfo) {
        this.amountInfo = amountInfo;
    }

    public String getSiteGrantType() {
        return this.siteGrantType;
    }

    public void setSiteGrantType(String siteGrantType) {
        this.siteGrantType = siteGrantType;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getExtGrantId() {
        return this.extGrantId;
    }

    public void setExtGrantId(String extGrantId) {
        this.extGrantId = extGrantId;
    }

    public String getAllTitles() {
        return this.allTitles;
    }

    public void setAllTitles(String allTitles) {
        this.allTitles = allTitles;
    }

    public String getSubmissionInfo() {
        return this.submissionInfo;
    }

    public void setSubmissionInfo(String submissionInfo) {
        this.submissionInfo = submissionInfo;
    }

    public String getAllGrantSourceUrls() {
        return this.allGrantSourceUrls;
    }

    public void setAllGrantSourceUrls(String allGrantSourceUrls) {
        this.allGrantSourceUrls = allGrantSourceUrls;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEligibility() {
        return this.eligibility;
    }

    public void setEligibility(String eligibility) {
        this.eligibility = eligibility;
    }

    public String getCategoriesDisplay() {
        return this.categoriesDisplay;
    }

    public void setCategoriesDisplay(String categoriesDisplay) {
        this.categoriesDisplay = categoriesDisplay;
    }

    public String getCategoriesDisplayForDisplay() {
        String cd = this.getCategoriesDisplay();
        if (StringUtils.isBlank((CharSequence)cd)) {
            return cd;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map map = (Map)mapper.readValue(this.getCategoriesDisplay(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
            List<String> result = this.keys(map, new ArrayList<String>());
            return String.join((CharSequence)"; ", result);
        }
        catch (JsonProcessingException | RuntimeException e) {
            return this.getCategoriesDisplay();
        }
    }

    private List<String> keys(Map<String, Object> map, List<String> accumulator) {
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                this.keys(mapValue, accumulator);
            }
            accumulator.add((String)key);
        });
        return accumulator;
    }

    public String getLimitedGrantInfo() {
        return this.limitedGrantInfo;
    }

    public void setLimitedGrantInfo(String limitedGrantInfo) {
        this.limitedGrantInfo = limitedGrantInfo;
    }

    public String getReplaces() {
        return this.replaces;
    }

    public void setReplaces(String replaces) {
        this.replaces = replaces;
    }

    public String getUserCategories() {
        return this.userCategories;
    }

    public void setUserCategories(String userCategories) {
        this.userCategories = userCategories;
    }

    public String getUserCategoriesForDisplay() {
        String uc = this.getUserCategories();
        if (StringUtils.isBlank((CharSequence)uc)) {
            return uc;
        }
        return Stream.of(this.getUserCategories().split(";")).map(String::trim).collect(Collectors.joining("; "));
    }

    public String getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(String submitDate) {
        this.submitDate = submitDate;
    }

    public Integer getIsLimited() {
        return this.isLimited;
    }

    public void setIsLimited(Integer isLimited) {
        this.isLimited = isLimited;
    }

    public String getSiteCategories() {
        return this.siteCategories;
    }

    public void setSiteCategories(String siteCategories) {
        this.siteCategories = siteCategories;
    }

    public String getCostSharing() {
        return this.costSharing;
    }

    public void setCostSharing(String costSharing) {
        this.costSharing = costSharing;
    }

    public String getGrantSourceUrl() {
        return this.grantSourceUrl;
    }

    public void setGrantSourceUrl(String grantSourceUrl) {
        this.grantSourceUrl = grantSourceUrl;
    }

    public String getAllTypes() {
        return this.allTypes;
    }

    public void setAllTypes(String allTypes) {
        this.allTypes = allTypes;
    }

    public String getAllApplicantTypes() {
        return this.allApplicantTypes;
    }

    public void setAllApplicantTypes(String allApplicantTypes) {
        this.allApplicantTypes = allApplicantTypes;
    }

    public List<GrantForwardDeadline> getDeadlines() {
        return this.deadlines;
    }

    public void setDeadlines(List<GrantForwardDeadline> deadlines) {
        this.deadlines = deadlines;
    }

    public List<GrantForwardAmount> getAmounts() {
        return this.amounts;
    }

    public void setAmounts(List<GrantForwardAmount> amounts) {
        this.amounts = amounts;
    }

    public List<GrantForwardLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(List<GrantForwardLocation> locations) {
        this.locations = locations;
    }

    public List<GrantForwardSponsor> getSponsors() {
        return this.sponsors;
    }

    public void setSponsors(List<GrantForwardSponsor> sponsors) {
        this.sponsors = sponsors;
    }
}

