/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.questionnaire;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrintingService;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.print.ProposalDevelopmentPrintingService;
import org.kuali.coeus.sys.framework.controller.ControllerFileUtils;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentQuestionnaireController
extends ProposalDevelopmentControllerBase {
    @Autowired
    @Qualifier(value="questionnairePrintingService")
    private QuestionnairePrintingService questionnairePrintingService;
    @Autowired
    @Qualifier(value="proposalDevelopmentPrintingService")
    private ProposalDevelopmentPrintingService proposalDevelopmentPrintingService;

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropDev-QuestionnairePage"})
    public ModelAndView navigateToQuestionnaire(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService()).populateQuestionnaires(form);
        return super.navigate(form, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=saveQuestionnaire"})
    public ModelAndView saveQuestionnaire(@ModelAttribute(value="KualiForm") DocumentFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocumentForm pdForm = (ProposalDevelopmentDocumentForm)form;
        pdForm.getQuestionnaireHelper().preSave();
        this.getLegacyDataAdapter().save(pdForm.getQuestionnaireHelper().getAnswerHeaders());
        pdForm.getQuestionnaireHelper().populateAnswers();
        return super.save(pdForm, result, request, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=clearQuestionnaire"})
    public ModelAndView clearQuestionnaire(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response, @RequestParam(value="actionParameters[index]") String index, @RequestParam(value="actionParameters[helper]") String helper) throws Exception {
        if (helper.equals("questionnaireHelper")) {
            this.clearAnswers(form.getQuestionnaireHelper().getAnswerHeaders().get(Integer.parseInt(index)).getAnswers());
        } else if (helper.equals("s2sQuestionnaireHelper")) {
            this.clearAnswers(form.getS2sQuestionnaireHelper().getAnswerHeaders().get(Integer.parseInt(index)).getAnswers());
        }
        return super.save(form);
    }

    protected void clearAnswers(List<Answer> answers) {
        for (Answer answer : answers) {
            answer.setAnswer(null);
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareUpdateDialog"})
    public ModelAndView prepareUpdateDialog(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, @RequestParam(value="actionParameters[index]") String index, @RequestParam(value="actionParameters[helper]") String helper) throws Exception {
        if (helper.equals("questionnaireHelper")) {
            form.setUpdateAnswerHeader(form.getQuestionnaireHelper().getAnswerHeaders().get(Integer.parseInt(index)));
        } else if (helper.equals("s2sQuestionnaireHelper")) {
            form.setUpdateAnswerHeader(form.getS2sQuestionnaireHelper().getAnswerHeaders().get(Integer.parseInt(index)));
        }
        return this.getModelAndViewService().showDialog("PropDev-QuestionnairePage-UpdateDialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updateQuestionnaire"})
    public ModelAndView updateQuestionnaire(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) throws Exception {
        if (form.getQuestionnaireHelper().getAnswerHeaders().contains(form.getUpdateAnswerHeader())) {
            int index = form.getQuestionnaireHelper().getAnswerHeaders().indexOf(form.getUpdateAnswerHeader());
            form.getQuestionnaireHelper().updateQuestionnaireAnswer(index);
        } else if (form.getS2sQuestionnaireHelper().getAnswerHeaders().contains(form.getUpdateAnswerHeader())) {
            int index = form.getS2sQuestionnaireHelper().getAnswerHeaders().indexOf(form.getUpdateAnswerHeader());
            form.getS2sQuestionnaireHelper().updateQuestionnaireAnswer(index);
        }
        form.setUpdateAnswerHeader(new AnswerHeader());
        return super.save(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printQuestionnaire"})
    public ModelAndView printQuestionnaire(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response, @RequestParam(value="index") int index, @RequestParam(value="helper") String helper) throws Exception {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        AttachmentDataSource dataStream = null;
        if (StringUtils.equals((CharSequence)helper, (CharSequence)"questionnaireHelper")) {
            reportParameters.putAll(this.createReportParameters(form.getQuestionnaireHelper().getAnswerHeaders().get(index)));
            reportParameters.put("coeusModuleSubItemCode", "0");
            dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer(form.getDevelopmentProposal(), reportParameters);
        } else if (StringUtils.equals((CharSequence)helper, (CharSequence)"s2sQuestionnaireHelper")) {
            reportParameters.putAll(this.createReportParameters(form.getS2sQuestionnaireHelper().getAnswerHeaders().get(index)));
            reportParameters.put("coeusModuleSubItemCode", "2");
            dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer(form.getDevelopmentProposal(), reportParameters);
        } else if (StringUtils.equals((CharSequence)helper, (CharSequence)"proposalPersonQuestionnaireHelper")) {
            reportParameters.putAll(this.createReportParameters(form.getProposalPersonQuestionnaireHelper().getAnswerHeaders().get(index)));
            dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer(form.getProposalPersonQuestionnaireHelper().getProposalPerson(), reportParameters);
        } else {
            throw new RuntimeException(String.format("Do not know how to process printQuestionnaireAnswer for formProperty %s", helper));
        }
        if (dataStream.getData() != null) {
            ControllerFileUtils.streamToResponse(dataStream, response);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=printAllCertifications"})
    public ModelAndView printAllCertifications(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, HttpServletResponse response) throws Exception {
        AttachmentDataSource dataStream = this.getProposalDevelopmentPrintingService().printPersonCertificationQuestionnaire(form.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons());
        if (dataStream.getData() != null) {
            ControllerFileUtils.streamToResponse(dataStream, response);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected Map<String, Object> createReportParameters(AnswerHeader answerHeader) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("questionnaireSeqId", answerHeader.getQuestionnaire().getQuestionnaireSeqIdAsInteger());
        reportParameters.put("template", answerHeader.getQuestionnaire().getTemplate());
        reportParameters.put("id", answerHeader.getQuestionnaire().getId());
        return reportParameters;
    }

    public QuestionnairePrintingService getQuestionnairePrintingService() {
        return this.questionnairePrintingService;
    }

    public void setQuestionnairePrintingService(QuestionnairePrintingService questionnairePrintingService) {
        this.questionnairePrintingService = questionnairePrintingService;
    }

    public ProposalDevelopmentPrintingService getProposalDevelopmentPrintingService() {
        return this.proposalDevelopmentPrintingService;
    }

    public void setProposalDevelopmentPrintingService(ProposalDevelopmentPrintingService proposalDevelopmentPrintingService) {
        this.proposalDevelopmentPrintingService = proposalDevelopmentPrintingService;
    }
}

