/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.propdev.impl.s2s.AbstractS2sInfo;
import org.kuali.coeus.propdev.impl.s2s.FormPackageCompilationService;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.print.FormElements;

public class S2sPrintFormsInfo
extends AbstractS2sInfo {
    private List<FormElements> formElements = Collections.emptyList();

    public S2sPrintFormsInfo() {
    }

    public S2sPrintFormsInfo(List<FormElements> formElements, FormPackageCompilationService.JobExecResult jobExecResult, String downloadToken) {
        super(jobExecResult, downloadToken);
        this.formElements = formElements;
    }

    @Override
    public List<AuditError> getCombinedErrorsAndWarnings() {
        return this.formElements.stream().flatMap(s -> s.getErrors().stream()).sorted(Comparator.comparing(AuditError::getLevel)).collect(Collectors.toList());
    }

    @Override
    public boolean isInError() {
        return this.formElements.stream().flatMap(s -> s.getErrors().stream()).anyMatch(e -> e.getLevel() == AuditError.Level.ERROR);
    }

    public List<FormElements> getFormElements() {
        return this.formElements;
    }

    public void setFormElements(List<FormElements> formElements) {
        this.formElements = formElements;
    }
}

