/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormContract;
import org.kuali.coeus.propdev.api.s2s.UserAttachedFormService;
import org.kuali.coeus.propdev.impl.s2s.S2sUserAttachedForm;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="userAttachedFormService")
public class UserAttachedFormServiceImpl
implements UserAttachedFormService {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    public S2sUserAttachedFormContract findFormByProposalNumberAndNamespace(String proposalNumber, String namespace) {
        if (StringUtils.isBlank((CharSequence)proposalNumber)) {
            throw new IllegalArgumentException("proposalNumber is blank");
        }
        if (StringUtils.isBlank((CharSequence)namespace)) {
            throw new IllegalArgumentException("namespace is blank");
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("proposalNumber", proposalNumber);
        fieldMap.put("namespace", namespace);
        List userAttachedForms = this.dataObjectService.findMatching(S2sUserAttachedForm.class, QueryByCriteria.Builder.andAttributes(fieldMap).build()).getResults();
        return userAttachedForms.isEmpty() ? null : (S2sUserAttachedFormContract)userAttachedForms.iterator().next();
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

