/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.config;

import java.util.Map;
import org.kuali.coeus.sys.framework.rest.AuthServiceRestUtilService;
import org.kuali.coeus.sys.framework.rest.UnauthorizedAccessException;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.security.PropertySuppressionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="ConfigController")
@RequestMapping(value={"/api/v1/configuration"})
public class ConfigController {
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="authServiceRestUtilService")
    private AuthServiceRestUtilService authServiceRestUtilService;
    @Autowired
    @Qualifier(value="propertySuppressionService")
    private PropertySuppressionService propertySuppressionService;

    @GetMapping(value={"/"})
    public Map<String, String> getAllConfigs() {
        if (!this.authServiceRestUtilService.isServiceUser()) {
            throw new UnauthorizedAccessException();
        }
        return this.getPropertySuppressionService().suppressValueMap(this.configurationService.getAllProperties());
    }

    @GetMapping(value={"/{configKey:.+}"})
    public String getConfigValue(@PathVariable String configKey) {
        if (!this.authServiceRestUtilService.isServiceUser()) {
            throw new UnauthorizedAccessException();
        }
        return this.getPropertySuppressionService().suppressValue(configKey, this.configurationService.getPropertyValueAsString(configKey));
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public AuthServiceRestUtilService getAuthServiceRestUtilService() {
        return this.authServiceRestUtilService;
    }

    public void setAuthServiceRestUtilService(AuthServiceRestUtilService authServiceRestUtilService) {
        this.authServiceRestUtilService = authServiceRestUtilService;
    }

    public PropertySuppressionService getPropertySuppressionService() {
        return this.propertySuppressionService;
    }

    public void setPropertySuppressionService(PropertySuppressionService propertySuppressionService) {
        this.propertySuppressionService = propertySuppressionService;
    }
}

