/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.interceptor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.rice.core.api.security.PropertySuppressionService;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.MimeType;
import org.springframework.web.filter.AbstractRequestLoggingFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

public class RequestLoggingFilter
extends AbstractRequestLoggingFilter {
    private static final Logger LOGGER = LogManager.getLogger(RequestLoggingFilter.class);
    private static final String COOKIE = "cookie";
    private Set<MediaType> contentTypeFilter = Collections.singleton(MediaType.ALL);
    private PropertySuppressionService propertySuppressionService;

    protected String createMessage(HttpServletRequest request, String prefix, String suffix) {
        ContentCachingRequestWrapper wrapper;
        String queryString;
        StringBuilder msg = new StringBuilder();
        msg.append(prefix);
        msg.append("uri=").append(request.getRequestURI());
        if (this.isIncludeQueryString() && (queryString = request.getQueryString()) != null) {
            msg.append('?').append(queryString);
        }
        if (this.isIncludeClientInfo()) {
            String user;
            HttpSession session;
            String client = request.getRemoteAddr();
            if (StringUtils.isNotEmpty((CharSequence)client)) {
                msg.append(";client=").append(client);
            }
            if ((session = request.getSession(false)) != null) {
                msg.append(";session=").append(session.getId());
            }
            if ((user = request.getRemoteUser()) != null) {
                msg.append(";user=").append(user);
            }
        }
        if (this.isIncludeHeaders()) {
            Map headers = this.getPropertySuppressionService().suppressValuesMap((Map)new ServletServerHttpRequest(request).getHeaders());
            Map suppressedHeaders = headers.entrySet().stream().map(header -> {
                if (((String)header.getKey()).equalsIgnoreCase(COOKIE)) {
                    return CollectionUtils.entry((String)header.getKey(), ((List)header.getValue()).stream().map(val -> this.getPropertySuppressionService().suppressionString()).collect(Collectors.toList()));
                }
                return CollectionUtils.entry((String)header.getKey(), (List)header.getValue());
            }).collect(CollectionUtils.entriesToMap());
            msg.append(";headers=").append(suppressedHeaders);
        }
        if (this.isIncludePayload() && (wrapper = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class)) != null) {
            byte[] buf = wrapper.getContentAsByteArray();
            msg.append(";payload size=").append(ArrayUtils.getLength((Object)buf));
        }
        msg.append(suffix);
        return msg.toString();
    }

    protected boolean shouldLog(HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            String contentTypeStr = request.getContentType();
            if (this.contentTypeFilter == null || this.contentTypeFilter.isEmpty() || StringUtils.isBlank((CharSequence)contentTypeStr)) {
                return true;
            }
            try {
                MediaType contentType = MediaType.parseMediaType((String)contentTypeStr);
                return this.contentTypeFilter.stream().anyMatch(filter -> filter.isCompatibleWith(contentType));
            }
            catch (InvalidMediaTypeException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    protected void beforeRequest(HttpServletRequest request, String message) {
        LOGGER.debug(message);
    }

    protected void afterRequest(HttpServletRequest request, String message) {
        LOGGER.debug(message);
    }

    public String getContentTypeFilterCsv() {
        if (this.contentTypeFilter == null) {
            return "";
        }
        return this.contentTypeFilter.stream().map(MimeType::getType).collect(Collectors.joining());
    }

    public void setContentTypeFilterCsv(String contentTypeFilterCsv) {
        this.contentTypeFilter = contentTypeFilterCsv == null ? null : Stream.of(contentTypeFilterCsv.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(MediaType::valueOf).collect(Collectors.toSet());
    }

    public Set<MediaType> getContentTypeFilter() {
        return this.contentTypeFilter;
    }

    public PropertySuppressionService getPropertySuppressionService() {
        return this.propertySuppressionService;
    }

    protected void initFilterBean() {
        this.propertySuppressionService = KcServiceLocator.getService(PropertySuppressionService.class);
    }
}

