/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.rest;

import com.google.common.base.CaseFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.coeus.sys.framework.controller.rest.SimpleCrudRestControllerBase;
import org.kuali.coeus.sys.framework.rest.ResourceNotFoundException;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RequestMapping(value={"/api/v1/endpoints"})
public class RestEndpointController
extends RestController {
    private static final Pattern MAPPING_REGEX = Pattern.compile("/(api)/(v\\d*)/(.*)/(.*)");
    private static final String BLUEPRINT_PARM = "_blueprint";
    @Autowired
    private List<HandlerMapping> mappings;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public Collection<EndpointInfoDto> getAll() {
        return this.getEndpointUrls().map(this::mappingUrlToDto).collect(Collectors.toList());
    }

    @RequestMapping(value={"/{resource}"}, method={RequestMethod.GET})
    @ResponseBody
    public EndpointInfoDto get(@PathVariable String resource) {
        return this.getEndpointUrls().filter(url -> resource.equals(this.mappingUrlToResourceName((String)url))).map(this::mappingUrlToDto).findFirst().orElseThrow(() -> new ResourceNotFoundException("endpoint not found"));
    }

    @RequestMapping(method={RequestMethod.GET}, params={"_blueprint"})
    @ResponseBody
    public Resource getAllBlueprint(HttpServletResponse response) throws IOException {
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment;filename=blueprint.zip");
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ByteArrayResource byteArrayResource;
            try (ZipOutputStream zipFile = new ZipOutputStream(stream);){
                this.getBlueprintEnabledControllers().collect(Collectors.toList()).forEach(ctrl -> {
                    Resource file = ctrl.getBlueprintResource();
                    try {
                        zipFile.putNextEntry(new ZipEntry((String)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)ctrl.getCamelCasePluralName()) + ".md"));
                        zipFile.setMethod(8);
                        zipFile.setLevel(5);
                        IOUtils.copy((InputStream)file.getInputStream(), (OutputStream)zipFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                zipFile.flush();
                zipFile.close();
                byteArrayResource = new ByteArrayResource(stream.toByteArray());
            }
            return byteArrayResource;
        }
    }

    @RequestMapping(value={"/{resource}"}, method={RequestMethod.GET}, params={"_blueprint"})
    @ResponseBody
    public Resource getBlueprint(@PathVariable String resource, HttpServletResponse response) {
        response.setContentType("text/markdown");
        response.setHeader("Content-Disposition", "attachment;filename=" + resource + ".md");
        return this.getBlueprintEnabledControllers().filter(ctrl -> resource.equals(CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_HYPHEN).convert((Object)ctrl.getCamelCasePluralName()))).map(SimpleCrudRestControllerBase::getBlueprintResource).findFirst().orElseThrow(() -> new ResourceNotFoundException("endpoint not found"));
    }

    protected Stream<String> getEndpointUrls() {
        return Stream.concat(this.mappings.stream().filter(mapping -> mapping instanceof SimpleUrlHandlerMapping).map(mapping -> (SimpleUrlHandlerMapping)mapping).flatMap(mapping -> mapping.getHandlerMap().entrySet().stream()).filter(entry -> entry.getValue() instanceof SimpleCrudRestControllerBase).map(this::cast).map(Map.Entry::getKey).filter(url -> MAPPING_REGEX.matcher((CharSequence)url).matches()), this.mappings.stream().filter(mapping -> mapping instanceof RequestMappingHandlerMapping).map(mapping -> (RequestMappingHandlerMapping)mapping).flatMap(mapping -> mapping.getHandlerMethods().entrySet().stream()).filter(entry -> SimpleCrudRestControllerBase.class.isAssignableFrom(((HandlerMethod)entry.getValue()).getBeanType())).map(this::cast).map(Map.Entry::getKey).flatMap(mappingInfo -> mappingInfo.getPatternsCondition().getPatterns().stream()).filter(pattern -> MAPPING_REGEX.matcher((CharSequence)pattern).matches())).filter(url -> !url.equals("/api/v1/endpoints/*")).distinct().sorted();
    }

    protected Stream<SimpleCrudRestControllerBase<?, ?>> getBlueprintEnabledControllers() {
        List endpointUrls = this.getEndpointUrls().collect(Collectors.toList());
        return Stream.concat(this.mappings.stream().filter(mapping -> mapping instanceof SimpleUrlHandlerMapping).map(mapping -> (SimpleUrlHandlerMapping)mapping).flatMap(mapping -> mapping.getHandlerMap().entrySet().stream()).filter(entry -> entry.getValue() instanceof SimpleCrudRestControllerBase).map(this::cast).filter(entry -> endpointUrls.stream().anyMatch(url -> url.equals(entry.getKey()))).map(Map.Entry::getValue), this.mappings.stream().filter(mapping -> mapping instanceof RequestMappingHandlerMapping).map(mapping -> (RequestMappingHandlerMapping)mapping).flatMap(mapping -> mapping.getHandlerMethods().entrySet().stream()).filter(entry -> SimpleCrudRestControllerBase.class.isAssignableFrom(((HandlerMethod)entry.getValue()).getBeanType())).filter(entry -> endpointUrls.stream().anyMatch(url -> ((RequestMappingInfo)entry.getKey()).getPatternsCondition().getPatterns().contains(url))).map(entry -> (SimpleCrudRestControllerBase)(((HandlerMethod)entry.getValue()).getBean() instanceof String ? KcServiceLocator.getService((String)((HandlerMethod)entry.getValue()).getBean()) : ((HandlerMethod)entry.getValue()).getBean()))).distinct().sorted(Comparator.comparing(mapping -> mapping.getDataObjectClazz().getName()));
    }

    private <T> Map.Entry<T, SimpleCrudRestControllerBase<?, ?>> cast(Map.Entry<T, ?> entry) {
        return entry;
    }

    protected EndpointInfoDto mappingUrlToDto(String url) {
        return new EndpointInfoDto(this.mappingUrlToResourceName(url), WordUtils.capitalizeFully((String)this.mappingUrlToResourceName(url).replaceAll("-", " ")), this.mappingUrlToUrl(url), new Random().nextInt());
    }

    protected String mappingUrlToResourceName(String url) {
        Matcher m = MAPPING_REGEX.matcher(url);
        return m.matches() ? m.group(3) : null;
    }

    protected String mappingUrlToUrl(String url) {
        Matcher m = MAPPING_REGEX.matcher(url);
        return m.matches() ? url.substring(0, m.start(4)) : null;
    }

    public List<HandlerMapping> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<HandlerMapping> mappings) {
        this.mappings = mappings;
    }

    private static class EndpointInfoDto {
        private String systemName;
        private String displayName;
        private String endpoint;
        private int order;

        public EndpointInfoDto(String systemName, String displayName, String endpoint, int order) {
            this.systemName = systemName;
            this.displayName = displayName;
            this.endpoint = endpoint;
            this.order = order;
        }

        public String getSystemName() {
            return this.systemName;
        }

        public void setSystemName(String systemName) {
            this.systemName = systemName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EndpointInfoDto)) {
                return false;
            }
            EndpointInfoDto that = (EndpointInfoDto)o;
            if (this.order != that.order) {
                return false;
            }
            if (!this.systemName.equals(that.systemName)) {
                return false;
            }
            if (!this.displayName.equals(that.displayName)) {
                return false;
            }
            return this.endpoint.equals(that.endpoint);
        }

        public int hashCode() {
            int result = this.systemName.hashCode();
            result = 31 * result + this.displayName.hashCode();
            result = 31 * result + this.endpoint.hashCode();
            result = 31 * result + this.order;
            return result;
        }

        public String toString() {
            return "EndpointInfoDto{systemName='" + this.systemName + "', displayName='" + this.displayName + "', endpoint='" + this.endpoint + "', order=" + this.order + "}";
        }
    }
}

