/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.keyvalue;

import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.keyvalue.PrefixValuesFinder;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.PersistableBusinessObjectValuesFinder;

public class ExtendedPersistableBusinessObjectValuesFinder
extends PersistableBusinessObjectValuesFinder {
    private static final Comparator<KeyValue> PBO_COMPARATOR = new PBOComparator();
    private static final ConcreteKeyValue SELECT_PREFIX = new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue());
    private static final Logger LOG = LogManager.getLogger(ExtendedPersistableBusinessObjectValuesFinder.class);

    public List<KeyValue> getKeyValues() {
        List labels = super.getKeyValues();
        labels.sort(PBO_COMPARATOR);
        labels.add(0, SELECT_PREFIX);
        return labels;
    }

    private static class PBOComparator
    implements Comparator<KeyValue> {
        private PBOComparator() {
        }

        @Override
        public int compare(KeyValue kv1, KeyValue kv2) {
            try {
                String desc1 = kv1.getValue();
                String desc2 = kv2.getValue();
                if (desc1 == null) {
                    desc1 = "";
                }
                if (desc2 == null) {
                    desc2 = "";
                }
                return desc1.compareTo(desc2);
            }
            catch (RuntimeException e) {
                LOG.error("Exception sorting KeyValues", (Throwable)e);
                return 0;
            }
        }
    }
}

