/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.health;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="healthCheckController")
public class HealthCheckController {
    protected static final String DEFAULT_HEALTH_QUERY = "select 1 from dual";
    protected final Logger LOG = LogManager.getLogger(HealthCheckController.class);
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;
    @Autowired
    @Qualifier(value="riceDataSource")
    private DataSource riceDataSource;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    private String kcHealthQuery = "select 1 from dual";
    private String riceHealthQuery = "select 1 from dual";

    @RequestMapping(value={"/", "/ebs"})
    public ResponseEntity<HealthResponse> doHealthCheck() {
        HealthResponse result = new HealthResponse();
        result.version = this.configurationService.getPropertyValueAsString("version") + " " + this.configurationService.getPropertyValueAsString("proj.date");
        try (Connection conn = this.dataSource.getConnection();
             Connection riceConn = this.riceDataSource.getConnection();
             Statement stmt = conn.createStatement();
             Statement riceStmt = riceConn.createStatement();
             ResultSet resultSet = stmt.executeQuery(this.kcHealthQuery);
             ResultSet riceResultSet = riceStmt.executeQuery(this.riceHealthQuery);){
            if (resultSet.next()) {
                result.kcDatabaseUp = true;
            }
            if (riceResultSet.next()) {
                result.riceDatabaseUp = true;
            }
            result.overallStatus = result.kcDatabaseUp && result.riceDatabaseUp ? "OK" : "Failed";
        }
        catch (Exception e) {
            this.LOG.error("Health Check Failed.", (Throwable)e);
            return new ResponseEntity((Object)result, HttpStatus.EXPECTATION_FAILED);
        }
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getRiceDataSource() {
        return this.riceDataSource;
    }

    public void setRiceDataSource(DataSource riceDataSource) {
        this.riceDataSource = riceDataSource;
    }

    public String getKcHealthQuery() {
        return this.kcHealthQuery;
    }

    public void setKcHealthQuery(String kcHealthQuery) {
        this.kcHealthQuery = kcHealthQuery;
    }

    public String getRiceHealthQuery() {
        return this.riceHealthQuery;
    }

    public void setRiceHealthQuery(String riceHealthQuery) {
        this.riceHealthQuery = riceHealthQuery;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public static class HealthResponse {
        public String version = "NO VERSION";
        public boolean kcDatabaseUp;
        public boolean riceDatabaseUp;
        public String overallStatus = "OK";
    }
}

