/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.ksb;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.impl.ksb.KsbRequeue;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.ksb.messaging.MessageServiceInvoker;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.service.MessageQueueService;
import org.kuali.rice.ksb.messaging.threadpool.KSBThreadPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="ksbRequeue")
public class KsbRequeueImpl
implements KsbRequeue {
    private static final Logger LOG = LogManager.getLogger(KsbRequeueImpl.class);
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="rice.ksb.threadPool")
    private KSBThreadPool ksbThreadPool;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="rice.ksb.messageQueueService")
    private MessageQueueService messageQueueService;

    @Override
    public void requeueKsbMessages() {
        String ageStr = this.configurationService.getPropertyValueAsString("rice.ksb.requeue.minutes");
        String maxRetryStr = this.configurationService.getPropertyValueAsString("RouteQueue.maxRetryAttempts");
        long age = Long.parseLong(ageStr) * 60L * 1000L;
        int maxRetry = Integer.parseInt(maxRetryStr);
        Predicate tooOld = PredicateFactory.lessThanOrEqual((String)"queueDate", (Object)new Timestamp(System.currentTimeMillis() - age));
        Predicate canRetry = PredicateFactory.lessThanOrEqual((String)"retryCount", (Object)maxRetry);
        QueryByCriteria criteria = QueryByCriteria.Builder.fromPredicates((Predicate[])new Predicate[]{tooOld, canRetry});
        QueryResults results = this.dataObjectService.findMatching(PersistedMessageBO.class, criteria);
        List messages = results.getResults();
        if (!messages.isEmpty()) {
            LOG.warn("Re-queueing messages: " + String.valueOf(messages));
            messages.forEach(m -> {
                try {
                    this.getKsbThreadPool().execute((Runnable)new MessageServiceInvoker(this.quickRequeueMessage((PersistedMessageBO)m)));
                }
                catch (Throwable t) {
                    LOG.error("failed to requeue message " + String.valueOf(m), t);
                }
            });
        }
    }

    protected PersistedMessageBO quickRequeueMessage(PersistedMessageBO message) {
        message.setQueueStatus("R");
        message.setQueueDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        message.setRetryCount(Integer.valueOf(message.getRetryCount() != null ? message.getRetryCount() + 1 : 1));
        return this.getMessageQueueService().save(message);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public KSBThreadPool getKsbThreadPool() {
        return this.ksbThreadPool;
    }

    public void setKsbThreadPool(KSBThreadPool ksbThreadPool) {
        this.ksbThreadPool = ksbThreadPool;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public MessageQueueService getMessageQueueService() {
        return this.messageQueueService;
    }

    public void setMessageQueueService(MessageQueueService messageQueueService) {
        this.messageQueueService = messageQueueService;
    }
}

