/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.session.ser;

import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.impl.session.ser.SerializableLogger;
import org.kuali.coeus.sys.impl.session.ser.SerializableSessionAttributeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="serializableLogger")
public class SerializableLoggerImpl
implements SerializableLogger {
    private Logger LOG = LogManager.getLogger(SerializableLoggerImpl.class);
    @Autowired
    @Qualifier(value="serializableKradFormService")
    private SerializableSessionAttributeService serializableKradFormService;
    @Autowired
    @Qualifier(value="serializableSessionAttributeService")
    private SerializableSessionAttributeService serializableSessionAttributeService;
    @Autowired
    @Qualifier(value="serializableUserSessionAttributeService")
    private SerializableSessionAttributeService serializableUserSessionAttributeService;

    @Override
    public void log() {
        if (this.LOG.isWarnEnabled()) {
            Stream.concat(Stream.concat(this.serializableSessionAttributeService.getAttributes().stream(), this.serializableUserSessionAttributeService.getAttributes().stream()), this.serializableKradFormService.getAttributes().stream()).filter(attr -> !attr.isSerializable()).forEach(attr -> this.LOG.warn("Serialization failed: " + String.valueOf(attr)));
        }
    }

    public SerializableSessionAttributeService getSerializableKradFormService() {
        return this.serializableKradFormService;
    }

    public void setSerializableKradFormService(SerializableSessionAttributeService serializableKradFormService) {
        this.serializableKradFormService = serializableKradFormService;
    }

    public SerializableSessionAttributeService getSerializableSessionAttributeService() {
        return this.serializableSessionAttributeService;
    }

    public void setSerializableSessionAttributeService(SerializableSessionAttributeService serializableSessionAttributeService) {
        this.serializableSessionAttributeService = serializableSessionAttributeService;
    }

    public SerializableSessionAttributeService getSerializableUserSessionAttributeService() {
        return this.serializableUserSessionAttributeService;
    }

    public void setSerializableUserSessionAttributeService(SerializableSessionAttributeService serializableUserSessionAttributeService) {
        this.serializableUserSessionAttributeService = serializableUserSessionAttributeService;
    }
}

