/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.document.authorizer;

import org.kuali.coeus.common.framework.auth.task.Task;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.budget.document.authorization.AwardBudgetTask;
import org.kuali.kra.award.budget.document.authorizer.BudgetAuthorizer;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;

public class ToggleAwardBudgetStatusAuthorizer
extends BudgetAuthorizer {
    private AwardBudgetService awardBudgetService;

    @Override
    public boolean isAuthorized(String userId, Task task) {
        AwardBudgetTask budgetTask = (AwardBudgetTask)task;
        AwardBudgetDocument budgetDocument = budgetTask.getAwardBudgetDocument();
        AwardDocument doc = (AwardDocument)budgetDocument.getBudget().getBudgetParent().getDocument();
        WorkflowDocument workflowDoc = this.getWorkflowDocument(budgetDocument);
        return workflowDoc.isFinal() && this.isToggleAwardBudgetStatusValid(budgetDocument) && this.hasUnitPermission(userId, doc.getLeadUnitNumber(), "KC-AB", AwardPermissionConstants.MAINTAIN_AWARD_BUDGET_ROUTING.getAwardPermission());
    }

    private boolean isToggleAwardBudgetStatusValid(AwardBudgetDocument budgetDocument) {
        String toBePostedStatusCode = this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusToBePosted");
        String doNotPostStatusCode = this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusDoNotPost");
        String errorInPostStatusCode = this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetStatusPostError");
        String budgetStatusCode = budgetDocument.getAwardBudget().getAwardBudgetStatusCode();
        boolean isLatestBudgetAndDoNotPost = this.getAwardBudgetService().isLatestBudgetVersion(budgetDocument) && budgetStatusCode.equals(doNotPostStatusCode);
        return budgetStatusCode.equals(toBePostedStatusCode) || budgetStatusCode.equals(errorInPostStatusCode) || isLatestBudgetAndDoNotPost;
    }

    public AwardBudgetService getAwardBudgetService() {
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }

    public ParameterService getParameterService() {
        return CoreFrameworkServiceLocator.getParameterService();
    }
}

