/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationDetails;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationJobDetail;
import org.kuali.rice.krad.UserSession;
import org.quartz.JobExecutionContext;
import org.springframework.transaction.annotation.Transactional;

public class ReportTrackingDigestNotificationJobDetail
extends ReportTrackingNotificationJobDetail {
    private static final Logger LOG = LogManager.getLogger(ReportTrackingNotificationJobDetail.class);
    private static final String ACTION_CODE_JOB_MAP_KEY = "actionCode";
    private static final String NOTIFICATION_NAME_JOB_MAP_KEY = "notificationName";
    private static final String INCLUDE_DUE_JOB_MAP_KEY = "includeDue";
    private static final String INCLUDE_OVERDUE_JOB_MAP_KEY = "includeOverdue";
    private GlobalVariableService globalVariableService;
    private String user;

    @Override
    @Transactional
    protected void executeInternal(JobExecutionContext context) {
        String actionCode = this.getActionCode(context);
        String notificationName = this.getNotificationName(context);
        boolean includeDue = this.isIncludeDue(context);
        boolean includeOverdue = this.isIncludeOverdue(context);
        this.globalVariableService.doInNewGlobalVariables(new UserSession(this.user), () -> {
            StringBuilder builder = new StringBuilder();
            try {
                ReportTrackingNotificationDetails results = this.getReportTrackingNotificationService().runReportDigestNotification(actionCode, notificationName, includeDue, includeOverdue);
                this.buildMessage(builder, Collections.singletonList(results));
            }
            catch (Exception e) {
                LOG.error("Error running report tracking digest notifications", (Throwable)e);
                builder.append("Message: Error running report tracking digest notifications. See log for more details. " + e.getMessage());
            }
            this.logAndSendResults(builder.toString());
            return null;
        });
    }

    protected GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    protected String getActionCode(JobExecutionContext context) {
        return (String)context.getJobDetail().getJobDataMap().get((Object)ACTION_CODE_JOB_MAP_KEY);
    }

    protected String getNotificationName(JobExecutionContext context) {
        return (String)context.getJobDetail().getJobDataMap().get((Object)NOTIFICATION_NAME_JOB_MAP_KEY);
    }

    protected boolean isIncludeDue(JobExecutionContext context) {
        String includeDue = (String)context.getJobDetail().getJobDataMap().get((Object)INCLUDE_DUE_JOB_MAP_KEY);
        return includeDue == null || Boolean.valueOf(includeDue) != false;
    }

    protected boolean isIncludeOverdue(JobExecutionContext context) {
        String includeOverdue = (String)context.getJobDetail().getJobDataMap().get((Object)INCLUDE_OVERDUE_JOB_MAP_KEY);
        return includeOverdue == null || Boolean.valueOf(includeOverdue) != false;
    }
}

