/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder;
import org.kuali.kra.award.lookup.keyvalue.FrequencyCodeValuesFinder;
import org.kuali.kra.award.lookup.keyvalue.ReportClassValuesFinder;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.service.AwardReportsService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AwardReportsServiceImpl
implements AwardReportsService {
    private ParameterService parameterService;
    private BusinessObjectService businessObjectService;

    @Override
    public Map<String, Object> initializeObjectsForReportsAndPayments(Award award) {
        HashMap<String, Object> initializedObjects = new HashMap<String, Object>();
        this.assignReportClassesForPanelHeaderDisplay(initializedObjects);
        this.addEmptyNewAwardReportTermRecipients(award, initializedObjects);
        this.setReportClassForPaymentsAndInvoicesSubPanel(initializedObjects);
        return initializedObjects;
    }

    protected void setReportClassForPaymentsAndInvoicesSubPanel(Map<String, Object> hashMap) {
        HashMap<String, String> primaryKeyField = new HashMap<String, String>();
        primaryKeyField.put("reportClassCode", this.getParameterService().getParameterValueAsString(AwardDocument.class, "reportClassForPaymentsAndInvoices"));
        hashMap.put("reportClassForPaymentsAndInvoicesPanel", (ReportClass)this.getBusinessObjectService().findByPrimaryKey(ReportClass.class, primaryKeyField));
    }

    protected void assignReportClassesForPanelHeaderDisplay(Map<String, Object> hashMap) {
        ReportClassValuesFinder reportClassValuesFinder = this.getReportClassValuesFinder();
        ArrayList<KeyValue> reportClasses = new ArrayList();
        reportClasses = reportClassValuesFinder.getKeyValues();
        hashMap.put("reportClasses", reportClasses);
        this.addEmptyNewAwardReportTerms(hashMap, reportClasses);
    }

    protected void addEmptyNewAwardReportTerms(Map<String, Object> hashMap, List<KeyValue> reportClasses) {
        ArrayList<AwardReportTerm> newAwardReportTerms = new ArrayList<AwardReportTerm>();
        for (KeyValue KeyValue2 : reportClasses) {
            newAwardReportTerms.add(new AwardReportTerm());
        }
        hashMap.put("newAwardReportTermList", newAwardReportTerms);
    }

    protected void addEmptyNewAwardReportTermRecipients(Award award, Map<String, Object> hashMap) {
        ArrayList<AwardReportTermRecipient> newAwardReportTermRecipients = new ArrayList<AwardReportTermRecipient>();
        for (AwardReportTerm awardReportTerm : award.getAwardReportTermItems()) {
            newAwardReportTermRecipients.add(new AwardReportTermRecipient());
        }
        hashMap.put("newAwardReportTermRecipientsList", newAwardReportTermRecipients);
    }

    @Override
    public String getFrequencyCodes(String reportClassCode, String reportCode) {
        FrequencyCodeValuesFinder frequencyCodeValuesFinder = this.getFrequencyCodeValuesFinder(reportClassCode, reportCode);
        return ValuesFinderUtils.processKeyValueList(frequencyCodeValuesFinder.getKeyValues());
    }

    @Override
    public String getFrequencyBaseCodes(String frequencyCode) {
        FrequencyBaseCodeValuesFinder frequencyBaseCodeValuesFinder = this.getFrequencyBaseCodeValuesFinder(frequencyCode);
        return ValuesFinderUtils.processKeyValueList(frequencyBaseCodeValuesFinder.getKeyValues());
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected FrequencyCodeValuesFinder getFrequencyCodeValuesFinder(String reportClassCode, String reportCode) {
        return new FrequencyCodeValuesFinder(reportClassCode, reportCode);
    }

    protected FrequencyBaseCodeValuesFinder getFrequencyBaseCodeValuesFinder(String frequencyCode) {
        return new FrequencyBaseCodeValuesFinder(frequencyCode);
    }

    protected ReportClassValuesFinder getReportClassValuesFinder() {
        return new ReportClassValuesFinder();
    }
}

