/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.FrequencyBase;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.ValidClassReportFrequency;
import org.kuali.kra.award.paymentreports.ValidFrequencyBase;
import org.kuali.kra.award.service.AwardTemplateReportTermService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardTemplateReportTermServiceImpl
implements AwardTemplateReportTermService {
    private BusinessObjectService businessObjectService;

    @Override
    public String getReportTypeForAjaxCall(String reportClassCode) {
        Collection<String> reportTypes = this.getReportTypesUsingReportClassCode(reportClassCode);
        Object attributeNames = "";
        for (String aReportCode : reportTypes) {
            Report aReport = (Report)this.businessObjectService.findBySinglePrimaryKey(Report.class, (Object)aReportCode);
            if (aReport == null) continue;
            attributeNames = (String)attributeNames + "," + String.valueOf(aReportCode) + ";" + aReport.getDescription();
        }
        return attributeNames;
    }

    @Override
    public Collection<String> getReportTypesUsingReportClassCode(String reportClassCode) {
        this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> classReportFreqParams = new HashMap<String, String>();
        classReportFreqParams.put("reportClassCode", reportClassCode);
        List coll = this.businessObjectService.findMatching(ValidClassReportFrequency.class, classReportFreqParams);
        HashSet<String> reportTypes = new HashSet<String>();
        if (!coll.isEmpty()) {
            for (ValidClassReportFrequency aVcrf : coll) {
                reportTypes.add(aVcrf.getReportCode());
            }
        }
        return reportTypes;
    }

    @Override
    public String getFrequencyForAjaxCall(String reportCode, String reportClass) {
        Collection<String> frequencyCodes = this.getFrequencyUsingReportCodeAndClass(reportCode, reportClass);
        Object attributeNames = "";
        for (String aFrequencyCode : frequencyCodes) {
            Frequency aFrequency = (Frequency)this.businessObjectService.findBySinglePrimaryKey(Frequency.class, (Object)aFrequencyCode);
            if (aFrequency == null) continue;
            attributeNames = (String)attributeNames + "," + String.valueOf(aFrequencyCode) + ";" + aFrequency.getDescription();
        }
        return attributeNames;
    }

    @Override
    public Collection<String> getFrequencyUsingReportCodeAndClass(String reportCode, String reportClass) {
        this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> classReportFreqParams = new HashMap<String, String>();
        classReportFreqParams.put("reportCode", reportCode);
        classReportFreqParams.put("reportClassCode", reportClass);
        List coll = this.businessObjectService.findMatching(ValidClassReportFrequency.class, classReportFreqParams);
        HashSet<String> frequencyCodes = new HashSet<String>();
        if (!coll.isEmpty()) {
            for (ValidClassReportFrequency aVcrf : coll) {
                frequencyCodes.add(aVcrf.getFrequencyCode());
            }
        }
        return frequencyCodes;
    }

    @Override
    public String getFrequencyBaseForAjaxCall(String frequencyCode) {
        Collection<String> frequencyBaseCodes = this.getFrequencyBaseUsingFrequencyCode(frequencyCode);
        Object attributeNames = "";
        for (String aFrequencyBaseCode : frequencyBaseCodes) {
            FrequencyBase aFrequencyBase = (FrequencyBase)this.businessObjectService.findBySinglePrimaryKey(FrequencyBase.class, (Object)aFrequencyBaseCode);
            if (aFrequencyBase == null) continue;
            attributeNames = (String)attributeNames + "," + String.valueOf(aFrequencyBaseCode) + ";" + aFrequencyBase.getDescription();
        }
        return attributeNames;
    }

    @Override
    public Collection<String> getFrequencyBaseUsingFrequencyCode(String frequencyCode) {
        this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("frequencyCode", frequencyCode);
        List coll = this.businessObjectService.findMatching(ValidFrequencyBase.class, params);
        HashSet<String> frequencyBaseCodes = new HashSet<String>();
        if (!coll.isEmpty()) {
            for (ValidFrequencyBase aVcrf : coll) {
                frequencyBaseCodes.add(aVcrf.getFrequencyBaseCode());
            }
        }
        return frequencyBaseCodes;
    }
}

