/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.cgb.AwardCgb;
import org.kuali.kra.award.dao.AwardLookupDao;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.external.award.AwardBillingUpdateDto;
import org.kuali.kra.external.award.AwardBillingUpdateStatusDto;
import org.kuali.kra.external.award.AwardDTO;
import org.kuali.kra.external.award.AwardFieldValuesDto;
import org.kuali.kra.external.award.AwardSearchCriteriaDto;
import org.kuali.kra.external.award.AwardWebService;
import org.kuali.kra.external.service.KcDtoService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AwardWebServiceImpl
implements AwardWebService {
    private BusinessObjectService businessObjectService;
    private AwardService awardService;
    private AwardLookupDao awardLookupDao;
    private KcDtoService<AwardDTO, Award> awardDtoService;
    private ParameterService parameterService;

    @Override
    public AwardDTO getAward(Long awardId) {
        String awardNumber = this.getAwardService().getAwardNumber(awardId);
        if (StringUtils.isNotBlank((CharSequence)awardNumber)) {
            Award newestAward = this.getAwardService().getActiveOrNewestAward(awardNumber);
            AwardDTO result = this.getAwardDtoService().buildDto(newestAward);
            return result;
        }
        return null;
    }

    @Override
    public List<AwardDTO> searchAwards(AwardSearchCriteriaDto searchDto) {
        ArrayList<AwardDTO> results = new ArrayList<AwardDTO>();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("awardId", searchDto.getAwardId());
        values.put("financialChartOfAccountsCode", searchDto.getChartOfAccounts());
        values.put("accountNumber", searchDto.getAccountNumber());
        values.put("awardNumber", searchDto.getAwardNumber());
        values.put("projectPersons.personId", searchDto.getPrincipalInvestigatorId());
        values.put("sponsorCode", searchDto.getSponsorCode());
        values.put("beginDate", searchDto.getStartDate());
        values.put("rangeLowerBoundKeyPrefix_beginDate", searchDto.getStartDateLowerBound());
        values.put("awardAmountInfos.finalExpirationDate", searchDto.getEndDate());
        values.put("rangeLowerBoundKeyPrefix_awardAmountInfos.finalExpirationDate", searchDto.getEndDateLowerBound());
        values.put("awardAmountInfos.amountObligatedToDate", searchDto.getAwardTotal());
        String invoiceReportDesc = this.getParameterService().getParameterValueAsString(Award.class, "FIN_SYS_INVOICE_REPORT_DESC");
        values.put("awardReportTermItems.report.description", invoiceReportDesc);
        values.put("awardReportTermItems.frequencyCode", searchDto.getBillingFrequency());
        List<? extends BusinessObject> awards = this.getAwardLookupDao().getAwardSearchResults(values, false);
        if (awards != null && !awards.isEmpty()) {
            for (Award award : awards) {
                results.add(this.getAwardDtoService().buildDto(award));
            }
        }
        return results;
    }

    @Override
    public List<AwardDTO> getMatchingAwards(AwardFieldValuesDto fieldValuesDto) {
        ArrayList<AwardDTO> results = new ArrayList<AwardDTO>();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        if (fieldValuesDto.getAwardId() != null) {
            fieldValues.put("awardId", fieldValuesDto.getAwardId());
        }
        if (fieldValuesDto.getChartOfAccounts() != null) {
            fieldValues.put("financialChartOfAccountsCode", fieldValuesDto.getChartOfAccounts());
        }
        if (fieldValuesDto.getAccountNumber() != null) {
            fieldValues.put("accountNumber", fieldValuesDto.getAccountNumber());
        }
        if (fieldValuesDto.getPrincipalInvestigatorId() != null) {
            fieldValues.put("projectPersons.personId", fieldValuesDto.getPrincipalInvestigatorId());
        }
        if (fieldValuesDto.getAwardNumber() != null) {
            fieldValues.put("awardNumber", fieldValuesDto.getAwardNumber());
        }
        fieldValues.put("awardSequenceStatus", VersionStatus.ACTIVE.name());
        Collection<Award> awards = this.getAwardService().retrieveAwardsByCriteria(fieldValues);
        if (awards != null && !awards.isEmpty()) {
            for (Award award : awards) {
                results.add(this.getAwardDtoService().buildDto(award));
            }
        }
        return results;
    }

    protected AwardService getAwardService() {
        return this.awardService;
    }

    @Autowired
    @Qualifier(value="awardService")
    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public AwardLookupDao getAwardLookupDao() {
        return this.awardLookupDao;
    }

    @Autowired
    @Qualifier(value="awardLookupDao")
    public void setAwardLookupDao(AwardLookupDao awardLookupDao) {
        this.awardLookupDao = awardLookupDao;
    }

    public KcDtoService<AwardDTO, Award> getAwardDtoService() {
        return this.awardDtoService;
    }

    public void setAwardDtoService(KcDtoService<AwardDTO, Award> awardDtoService) {
        this.awardDtoService = awardDtoService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public AwardBillingUpdateStatusDto updateAwardBillingStatus(AwardFieldValuesDto searchDto, AwardBillingUpdateDto updateDto) {
        AwardBillingUpdateStatusDto result = new AwardBillingUpdateStatusDto();
        AwardCgb award = null;
        if (StringUtils.isNotEmpty((CharSequence)searchDto.getChartOfAccounts()) && StringUtils.isNotEmpty((CharSequence)searchDto.getAccountNumber())) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("award.financialChartOfAccountsCode", searchDto.getChartOfAccounts());
            values.put("award.accountNumber", searchDto.getAccountNumber());
            values.put("awardSequenceStatus", VersionStatus.ACTIVE.name());
            ArrayList cgbAwards = new ArrayList(this.businessObjectService.findMatching(AwardCgb.class, values));
            if (!cgbAwards.isEmpty()) {
                award = (AwardCgb)cgbAwards.get(0);
            }
        }
        if (award == null) {
            result.setSuccess(false);
            result.getErrorMessages().add("Unable to find an award for update based on unique identifiers.");
            return result;
        }
        if (updateDto.isDoFinalBilledUpdate()) {
            award.setFinalBill(updateDto.isFinalBilledIndicator());
        }
        if (updateDto.isDoLastBillDateUpdate()) {
            award.setPreviousLastBilledDate(award.getLastBilledDate());
            award.setLastBilledDate(updateDto.getLastBillDate());
        }
        if (updateDto.isDoAmountToDrawUpdate()) {
            award.setAmountToDraw(new ScaleTwoDecimal(updateDto.getAmountToDraw()));
        }
        if (updateDto.isDoInvoiceDocStatusUpdate()) {
            award.setInvoiceDocumentStatus(updateDto.getInvoiceDocumentStatus());
        }
        if (updateDto.isDoLocCreationTypeUpdate()) {
            // empty if block
        }
        if (updateDto.isDoLocReviewUpdate()) {
            award.setLetterOfCreditReviewIndicator(updateDto.isLocReviewIndicator());
        }
        if (updateDto.isRestorePreviousBillDate()) {
            award.setLastBilledDate(award.getPreviousLastBilledDate());
            award.setPreviousLastBilledDate(null);
        }
        this.getBusinessObjectService().save((PersistableBusinessObject)award);
        result.setAwardNumber(award.getAwardNumber());
        result.setSuccess(true);
        return result;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

