/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.external.award.FinancialIndirectCostRecoveryTypeCode;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class FinancialIndirectCostRecoveryTypeCodeDocumentRule
extends KcMaintenanceDocumentRuleBase {
    private BusinessObjectService businessObjectService;

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        FinancialIndirectCostRecoveryTypeCode mapping = (FinancialIndirectCostRecoveryTypeCode)document.getNewMaintainableObject().getDataObject();
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete")) {
            if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
                result &= this.validateUniqueEntry(mapping);
                result &= this.checkExistence(mapping);
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean checkExistence(FinancialIndirectCostRecoveryTypeCode newMapping) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)newMapping.getRateClassCode()) && StringUtils.isNotBlank((CharSequence)newMapping.getRateTypeCode())) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("rateClassCode", newMapping.getRateClassCode());
            pkMap.put("rateTypeCode", newMapping.getRateTypeCode());
            RateType rateType = (RateType)this.getBusinessObjectService().findByPrimaryKey(RateType.class, pkMap);
            if (rateType == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.rateTypeCode", "error.rateType.not.exist", new String[]{newMapping.getRateClassCode(), newMapping.getRateTypeCode()});
                valid = false;
            }
        }
        return valid;
    }

    private boolean validateUniqueEntry(FinancialIndirectCostRecoveryTypeCode mapping) {
        String rateClass = mapping.getRateClassCode();
        String rateType = mapping.getRateTypeCode();
        boolean valid = true;
        if (rateClass != null && StringUtils.isNotBlank((CharSequence)rateClass) && rateType != null && StringUtils.isNotBlank((CharSequence)rateType)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("rateClassCode", rateClass);
            map.put("rateTypeCode", rateType);
            List results = this.getBusinessObjectService().findMatching(FinancialIndirectCostRecoveryTypeCode.class, map);
            if (results.size() > 0) {
                MessageMap errorMap = GlobalVariables.getMessageMap();
                String error = " RateClassCode: " + rateClass + " RateTypeCode: " + rateType;
                errorMap.putError("document.newMaintainableObject.icrTypeCode", "error.award.budget.icr.type.code.mapping.exists", new String[]{error});
            }
        }
        return valid;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }
}

