/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.award.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.external.award.AwardAccountDTO;
import org.kuali.kra.external.award.AwardAccountService;
import org.kuali.kra.external.service.KcDtoService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardAccountServiceImpl
implements AwardAccountService {
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private static final Logger LOG = LogManager.getLogger(AwardAccountServiceImpl.class);
    private KcDtoService<AwardAccountDTO, Award> awardAccountDtoService;

    @Override
    public List<AwardAccountDTO> getAwardAccounts(String financialAccountNumber, String chartOfAccounts) {
        if (ObjectUtils.isNull((Object)financialAccountNumber) || ObjectUtils.isNull((Object)chartOfAccounts)) {
            LOG.warn("One or both of the criteria sent was null.");
            return null;
        }
        List<Award> awards = this.getAwards(financialAccountNumber, chartOfAccounts);
        return this.getAwardAccountDTOs(awards);
    }

    protected List<AwardAccountDTO> getAwardAccountDTOs(List<Award> awards) {
        ArrayList<AwardAccountDTO> awardDTOs = new ArrayList<AwardAccountDTO>();
        if (ObjectUtils.isNotNull(awards)) {
            for (Award award : awards) {
                awardDTOs.add(this.awardAccountDtoService.buildDto(award));
            }
        }
        return awardDTOs;
    }

    protected List<Award> getAwards(String financialAccountNumber, String chartOfAccounts) {
        ArrayList<Award> awards = new ArrayList<Award>();
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        if (ObjectUtils.isNotNull((Object)financialAccountNumber)) {
            searchCriteria.put("accountNumber", financialAccountNumber);
            searchCriteria.put("financialChartOfAccountsCode", chartOfAccounts);
            searchCriteria.put("awardSequenceStatus", VersionStatus.ACTIVE.name());
            awards = new ArrayList(this.businessObjectService.findMatching(Award.class, searchCriteria));
        }
        if (ObjectUtils.isNull(awards) || awards.isEmpty()) {
            LOG.warn("No award found for the account number " + financialAccountNumber + " and chart chartOfAccounts");
        }
        return awards;
    }

    @Override
    public boolean isFinancialRestApiEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "All", "AWARD_POST_ENABLED");
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected KcDtoService<AwardAccountDTO, Award> getAwardAccountDtoService() {
        return this.awardAccountDtoService;
    }

    public void setAwardAccountDtoService(KcDtoService<AwardAccountDTO, Award> awardAccountDtoService) {
        this.awardAccountDtoService = awardAccountDtoService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }
}

