/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.institutionalproposal.document.authorization.InstitutionalProposalDocumentAuthorizer;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.rice.core.api.criteria.CountFlag;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class InstitutionalProposalLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1L;
    private static final String MERGE_PROPOSAL_LOG_ACTION = "mergeProposalLog.do";
    private static final String AWARD_HOME_ACTION = "awardHome.do";
    private static final String OPEN = "open";
    private static final String LOOKUP_UNIT_UNIT_NAME = "lookupUnit.unitName";
    private static final String LOOKUP_UNIT_UNIT_NUMBER = "lookupUnit.unitNumber";
    private static final String PROPOSAL_LOG_NUMBER = "proposalLogNumber";
    private static final String INSTITUTIONAL_PROPOSAL_NUMBER = "institutionalProposalNumber";
    private static final String MERGE_TO_INSTITUTIONAL_PROPOSAL = "mergeToInstitutionalProposal";
    private static final String SELECT = "select";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String PROPOSAL_STATE_TYPE_CODE = "proposalStateTypeCode";
    private static final String INST_PROPOSAL_ID = "instProposalId";
    private static final String DEV_PROPOSAL_NUMBER = "devProposalNumber";
    private static final String VIEW_DOCUMENT = "viewDocument";
    private static final String TRUE = "true";
    private static final String DOC_OPENED_FROM_IP_SEARCH = "docOpenedFromIPSearch";
    private static final String DOC_ID = "docId";
    private static final String INSTITUTIONAL_PROPOSAL_HOME_DO = "institutionalProposalHome.do";
    private static final String INSTITUTIONAL_PROPOSAL_DOCUMENT = "InstitutionalProposalDocument";
    private static final String PROJECT_PERSONS_UNITS_UNIT_UNIT_NAME = "projectPersons.units.unit.unitName";
    private static final String PROJECT_PERSONS_UNITS_UNIT_NUMBER = "projectPersons.units.unitNumber";
    public static final String SEARCH_RESULT_FILTERING_PARAMETER_NAME = "Institutional_Proposal_Search_Permissions_Filter";
    private boolean includeMainSearchCustomActionUrls;
    protected String proposalLogNumber;
    private boolean includeMergeCustomActionUrls;
    private InstitutionalProposalService institutionalProposalService;
    private InstitutionalProposalDocumentAuthorizer institutionalProposalDocumentAuthorizer;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="proposalDevelopmentService")
    private ProposalDevelopmentService proposalDevelopmentService;

    public boolean getSearchResultsActualSizeKnown() {
        return false;
    }

    public List<InstitutionalProposal> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        if (this.getBusinessObjectClass() == null) {
            this.setBusinessObjectClass(InstitutionalProposal.class);
        }
        HashMap<String, String> adjustedFieldValues = new HashMap<String, String>(fieldValues);
        this.configureCustomActions(fieldValues);
        adjustedFieldValues.remove("proposalSequenceStatus");
        adjustedFieldValues.put("proposalSequenceStatus", VersionStatus.ACTIVE.toString());
        String unitName = (String)adjustedFieldValues.get(LOOKUP_UNIT_UNIT_NAME);
        if (StringUtils.isNotEmpty((CharSequence)unitName)) {
            adjustedFieldValues.put(PROJECT_PERSONS_UNITS_UNIT_UNIT_NAME, unitName);
        }
        adjustedFieldValues.remove(LOOKUP_UNIT_UNIT_NAME);
        String unitNumber = (String)adjustedFieldValues.get(LOOKUP_UNIT_UNIT_NUMBER);
        if (StringUtils.isNotEmpty((CharSequence)unitNumber)) {
            adjustedFieldValues.put(PROJECT_PERSONS_UNITS_UNIT_NUMBER, unitNumber);
        }
        adjustedFieldValues.remove(LOOKUP_UNIT_UNIT_NUMBER);
        String devProposalNumber = (String)adjustedFieldValues.get(DEV_PROPOSAL_NUMBER);
        if (StringUtils.isNotEmpty((CharSequence)devProposalNumber) && StringUtils.isEmpty((CharSequence)((CharSequence)adjustedFieldValues.get(PROPOSAL_NUMBER)))) {
            InstitutionalProposal linkedIp = this.getProposalDevelopmentService().getInstitutionalProposal(devProposalNumber);
            if (linkedIp != null) {
                adjustedFieldValues.put(PROPOSAL_NUMBER, linkedIp.getProposalNumber());
            } else {
                return List.of();
            }
        }
        adjustedFieldValues.remove(DEV_PROPOSAL_NUMBER);
        List searchResults = super.getSearchResults(adjustedFieldValues);
        if (this.lookupIsFromAward(fieldValues)) {
            this.filterAlreadyLinkedProposals(searchResults);
            this.filterApprovedPendingSubmitProposals(searchResults);
            this.filterInvalidProposalStatus(searchResults);
        }
        return this.filterForPermissions(searchResults);
    }

    protected boolean isPermissionFilteringEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-IP", "Document", SEARCH_RESULT_FILTERING_PARAMETER_NAME);
    }

    protected List<InstitutionalProposal> filterForPermissions(List<InstitutionalProposal> results) {
        if (!this.isPermissionFilteringEnabled()) {
            return results;
        }
        Person user = GlobalVariables.getUserSession().getPerson();
        InstitutionalProposalDocumentAuthorizer authorizer = this.getInstitutionalProposalDocumentAuthorizer();
        List<InstitutionalProposal> filteredResults = CollectionUtils.createCorrectImplementationForCollection(results);
        filteredResults.addAll(results.stream().filter(institutionalProposal -> authorizer.canOpen(institutionalProposal.getInstitutionalProposalDocument(), user)).collect(Collectors.toList()));
        return filteredResults;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.includeMainSearchCustomActionUrls) {
            htmlDataList.add((HtmlData)this.getOpenLink(((InstitutionalProposal)businessObject).getInstitutionalProposalDocument()));
        }
        if (this.includeMergeCustomActionUrls) {
            htmlDataList.add((HtmlData)this.getSelectLink((InstitutionalProposal)businessObject));
        }
        htmlDataList.add((HtmlData)this.getMedusaLink(((InstitutionalProposal)businessObject).getInstitutionalProposalDocument().getDocumentNumber(), false));
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(Document document) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(OPEN);
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put(VIEW_DOCUMENT, TRUE);
        parameters.put(DOC_OPENED_FROM_IP_SEARCH, TRUE);
        parameters.put(DOC_ID, document.getDocumentNumber());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    @Override
    protected String getHtmlAction() {
        return INSTITUTIONAL_PROPOSAL_HOME_DO;
    }

    @Override
    protected String getDocumentTypeName() {
        return INSTITUTIONAL_PROPOSAL_DOCUMENT;
    }

    @Override
    protected String getKeyFieldName() {
        return PROPOSAL_NUMBER;
    }

    protected boolean lookupIsFromAward(Map<String, String> fieldValues) {
        String returnLocation = fieldValues.get("backLocation");
        return returnLocation != null && returnLocation.contains(AWARD_HOME_ACTION);
    }

    protected void filterAlreadyLinkedProposals(List<InstitutionalProposal> searchResults) {
        List linkedProposals = (List)GlobalVariables.getUserSession().retrieveObject("linkedProposals");
        if (linkedProposals == null) {
            return;
        }
        block0: for (Long linkedProposalId : linkedProposals) {
            for (InstitutionalProposal searchResult : searchResults) {
                if (!linkedProposalId.equals(searchResult.getProposalId())) continue;
                searchResult.setShowReturnLink(false);
                continue block0;
            }
        }
    }

    protected void filterApprovedPendingSubmitProposals(List<InstitutionalProposal> searchResults) {
        searchResults.stream().filter(this::isDevelopmentProposalAppPendingSubmitted).forEach(searchResult -> searchResult.setShowReturnLink(false));
    }

    protected void filterInvalidProposalStatus(List<InstitutionalProposal> searchResults) {
        Collection<String> validCodes = this.getInstitutionalProposalService().getValidFundingProposalStatusCodes();
        searchResults.stream().filter(searchResult -> !validCodes.contains(searchResult.getStatusCode().toString())).forEach(searchResult -> searchResult.setShowReturnLink(false));
    }

    protected boolean isDevelopmentProposalAppPendingSubmitted(InstitutionalProposal ip) {
        List proposalAdminDetails = this.businessObjectService.findMatchingOrderBy(ProposalAdminDetails.class, this.getFieldValues(INST_PROPOSAL_ID, ip.getProposalId()), DEV_PROPOSAL_NUMBER, true);
        if (!proposalAdminDetails.isEmpty()) {
            String latestDevelopmentProposalDocNumber = ((ProposalAdminDetails)proposalAdminDetails.get(proposalAdminDetails.size() - 1)).getDevProposalNumber();
            QueryByCriteria criteria = QueryByCriteria.Builder.create().setPredicates(new Predicate[]{PredicateFactory.equal((String)PROPOSAL_NUMBER, (Object)latestDevelopmentProposalDocNumber), PredicateFactory.equal((String)PROPOSAL_STATE_TYPE_CODE, (Object)"5")}).setCountFlag(CountFlag.ONLY).build();
            return this.dataObjectService.findMatching(DevelopmentProposal.class, criteria).getTotalRowCount() > 0;
        }
        return false;
    }

    protected Map<String, Object> getFieldValues(String key, Object value) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(key, value);
        return fieldValues;
    }

    protected void configureCustomActions(Map<String, String> fieldValues) {
        String returnLocation = fieldValues.get("backLocation");
        if (returnLocation != null) {
            if (returnLocation.contains(AWARD_HOME_ACTION)) {
                this.includeMainSearchCustomActionUrls = false;
                this.includeMergeCustomActionUrls = false;
            } else if (returnLocation.contains(MERGE_PROPOSAL_LOG_ACTION)) {
                this.includeMainSearchCustomActionUrls = false;
                this.includeMergeCustomActionUrls = true;
                this.setProposalLogNumber(fieldValues.get(PROPOSAL_LOG_NUMBER));
            } else {
                this.includeMainSearchCustomActionUrls = true;
                this.includeMergeCustomActionUrls = false;
            }
        } else {
            this.includeMainSearchCustomActionUrls = false;
            this.includeMergeCustomActionUrls = false;
        }
    }

    protected HtmlData.AnchorHtmlData getSelectLink(InstitutionalProposal institutionalProposal) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(SELECT);
        Properties parameters = new Properties();
        parameters.put("methodToCall", MERGE_TO_INSTITUTIONAL_PROPOSAL);
        parameters.put(INSTITUTIONAL_PROPOSAL_NUMBER, institutionalProposal.getProposalNumber());
        if (this.getProposalLogNumber() != null) {
            parameters.put(PROPOSAL_LOG_NUMBER, this.getProposalLogNumber());
        }
        String href = UrlFactory.parameterizeUrl((String)"../mergeProposalLog.do", (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public boolean isResultReturnable(BusinessObject object) {
        InstitutionalProposal institutionalProposal = (InstitutionalProposal)object;
        return institutionalProposal.getShowReturnLink();
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    protected DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ProposalDevelopmentService getProposalDevelopmentService() {
        return this.proposalDevelopmentService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    protected void setProposalLogNumber(String proposalLogNumber) {
        this.proposalLogNumber = proposalLogNumber;
    }

    protected String getProposalLogNumber() {
        return this.proposalLogNumber;
    }

    protected InstitutionalProposalDocumentAuthorizer getInstitutionalProposalDocumentAuthorizer() {
        if (this.institutionalProposalDocumentAuthorizer == null) {
            return new InstitutionalProposalDocumentAuthorizer();
        }
        return this.institutionalProposalDocumentAuthorizer;
    }

    protected void setInstitutionalProposalDocumentAuthorizer(InstitutionalProposalDocumentAuthorizer institutionalProposalDocumentAuthorizer) {
        this.institutionalProposalDocumentAuthorizer = institutionalProposalDocumentAuthorizer;
    }
}

