/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class SubAwardFinancialAuditRule
extends KcTransactionalDocumentRuleBase
implements DocumentAuditRule {
    private static final String SUBAWARD_FINANCIAL_AUDIT_WARNINGS = "subawardFinancialdAuditWarnings";
    private List<AuditError> auditWarnings = new ArrayList<AuditError>();
    private ParameterService parameterService;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        this.auditWarnings = new ArrayList<AuditError>();
        valid &= this.checkForObligatedAmountZero(document);
        this.reportAndCreateFinancialAuditCluster();
        return valid &= this.checkForAnticipatedAmountZero(document);
    }

    protected void reportAndCreateFinancialAuditCluster() {
        if (this.auditWarnings.size() > 0) {
            AuditCluster existingErrors = (AuditCluster)GlobalVariables.getAuditErrorMap().get(SUBAWARD_FINANCIAL_AUDIT_WARNINGS);
            if (existingErrors == null) {
                GlobalVariables.getAuditErrorMap().put(SUBAWARD_FINANCIAL_AUDIT_WARNINGS, new AuditCluster("Financial", this.auditWarnings, "Warnings"));
            } else {
                existingErrors.getAuditErrorList().addAll(this.auditWarnings);
            }
        }
    }

    protected boolean checkForObligatedAmountZero(Document document) {
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        ScaleTwoDecimal obligatedAmount = ScaleTwoDecimal.ZERO;
        boolean isCostSplitEnabled = this.isCostSplitEnabled();
        for (SubAwardAmountInfo subAwardAmountInfo : subAwardDocument.getSubAward().getSubAwardAmountInfoList()) {
            if (!isCostSplitEnabled) {
                obligatedAmount = subAwardAmountInfo.getObligatedChange() != null ? (ScaleTwoDecimal)obligatedAmount.add((AbstractDecimal)subAwardAmountInfo.getObligatedChange()) : obligatedAmount;
                continue;
            }
            obligatedAmount = subAwardAmountInfo.getObligatedChangeDirect() != null ? (ScaleTwoDecimal)obligatedAmount.add((AbstractDecimal)subAwardAmountInfo.getObligatedChangeDirect()) : obligatedAmount;
            obligatedAmount = subAwardAmountInfo.getObligatedChangeIndirect() != null ? (ScaleTwoDecimal)obligatedAmount.add((AbstractDecimal)subAwardAmountInfo.getObligatedChangeIndirect()) : obligatedAmount;
        }
        if (obligatedAmount.isZero()) {
            subAwardDocument.getSubAward().setDefaultOpen(false);
            this.auditWarnings.add(new AuditError("document.subAwardList[0].totalObligatedAmount", "subaward.error.obligated.amount.equal.to.zero", "financial.Financial"));
            return false;
        }
        return true;
    }

    public boolean isCostSplitEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", "Enable_Subaward_DC_IDC");
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected boolean checkForAnticipatedAmountZero(Document document) {
        ScaleTwoDecimal anticipatedAmount = ScaleTwoDecimal.ZERO;
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        boolean isCostSplitEnabled = this.isCostSplitEnabled();
        for (SubAwardAmountInfo subAwardAmountInfo : subAwardDocument.getSubAward().getSubAwardAmountInfoList()) {
            if (!isCostSplitEnabled) {
                anticipatedAmount = subAwardAmountInfo.getAnticipatedChange() != null ? (ScaleTwoDecimal)anticipatedAmount.add((AbstractDecimal)subAwardAmountInfo.getAnticipatedChange()) : anticipatedAmount;
                continue;
            }
            anticipatedAmount = subAwardAmountInfo.getAnticipatedChangeDirect() != null ? (ScaleTwoDecimal)anticipatedAmount.add((AbstractDecimal)subAwardAmountInfo.getAnticipatedChangeDirect()) : anticipatedAmount;
            anticipatedAmount = subAwardAmountInfo.getAnticipatedChangeIndirect() != null ? (ScaleTwoDecimal)anticipatedAmount.add((AbstractDecimal)subAwardAmountInfo.getAnticipatedChangeIndirect()) : anticipatedAmount;
        }
        if (anticipatedAmount.isZero()) {
            subAwardDocument.getSubAward().setDefaultOpen(false);
            this.auditWarnings.add(new AuditError("document.subAwardList[0].totalAnticipatedAmount", "subaward.error.anticipated.amount.equal.to.zero", "financial.Financial"));
            return false;
        }
        return true;
    }
}

